/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;

public class GenericTileEntity
extends TileEntity
implements ICommandHandler,
IClientCommandHandler {
    public static final IValue<?>[] EMPTY_VALUES = new IValue[0];
    public static final IAction[] EMPTY_ACTIONS = new IAction[0];
    public static final String COMMAND_SYNC_BINDING = "generic.syncBinding";
    public static final String COMMAND_SYNC_ACTION = "generic.syncAction";
    public static final Key<String> PARAM_KEY = new Key<String>("key", Type.STRING);
    public static final Key<Integer> VALUE_RSMODE = new Key<Integer>("rsmode", Type.INTEGER);
    private String ownerName = "";
    private UUID ownerUUID = null;
    private int securityChannel = -1;
    protected RedstoneMode rsMode = RedstoneMode.REDSTONE_IGNORED;
    protected int powerLevel = 0;

    public GenericTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void markDirtyQuick() {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public IValue<?>[] getValues() {
        return EMPTY_VALUES;
    }

    public IAction[] getActions() {
        return EMPTY_ACTIONS;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
    }

    public void onPartAdded(PartSlot slot, BlockState state, TileEntity multipartTile) {
    }

    public ActionResultType onBlockActivated(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return ActionResultType.PASS;
    }

    protected boolean needsRedstoneMode() {
        return false;
    }

    public void checkRedstone(World world, BlockPos pos) {
        int powered = world.func_175687_A(pos);
        this.setPowerInput(powered);
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.func_70296_d();
        }
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public RedstoneMode getRSMode() {
        return this.rsMode;
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        this.rsMode = redstoneMode;
        this.markDirtyClient();
    }

    public void setRSModeInt(int i) {
        this.rsMode = RedstoneMode.values()[i];
        this.markDirtyClient();
    }

    public int getRSModeInt() {
        return this.rsMode.ordinal();
    }

    public boolean isMachineEnabled() {
        if (this.rsMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powerLevel > 0;
            if (this.rsMode == RedstoneMode.REDSTONE_OFFREQUIRED && rs) {
                return false;
            }
            if (this.rsMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return false;
            }
        }
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.readClientDataFromNBT(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.writeClientDataToNBT(nbtTag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.readClientDataFromNBT(packet.func_148857_g());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlayerAccess(PlayerEntity player) {
        if (this.func_145837_r()) return false;
        Vec3d vec3d = new Vec3d((Vec3i)this.field_174879_c);
        if (!(player.func_195048_a(vec3d.func_72441_c(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.writeClientDataToNBT(updateTag);
        return updateTag;
    }

    public void writeClientDataToNBT(CompoundNBT tagCompound) {
        this.func_189515_b(tagCompound);
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
        this.func_145839_a(tagCompound);
    }

    public void syncDataForGUI(Object[] data) {
    }

    public Object[] getDataForGUI() {
        return new Object[0];
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.readCaps(tagCompound);
        this.readInfo(tagCompound);
    }

    protected void readCaps(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            this.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> h.setInfused(infoTag.func_74762_e("infused")));
        }
        this.readItemHandlerCap(tagCompound);
        this.readEnergyCap(tagCompound);
    }

    protected void readItemHandlerCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> h.deserializeNBT((INBT)tagCompound.func_150295_c("Items", 10)));
    }

    protected void readEnergyCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityEnergy.ENERGY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> {
            if (tagCompound.func_74764_b("Energy")) {
                h.deserializeNBT(tagCompound.func_74781_a("Energy"));
            }
        });
    }

    protected void readInfo(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            this.powerLevel = infoTag.func_74771_c("powered");
            if (this.needsRedstoneMode()) {
                byte m = infoTag.func_74771_c("rsMode");
                this.rsMode = RedstoneMode.values()[m];
            }
            this.ownerName = infoTag.func_74779_i("owner");
            this.ownerUUID = infoTag.func_186857_a("ownerId");
            this.securityChannel = infoTag.func_74764_b("secChannel") ? infoTag.func_74762_e("secChannel") : -1;
        } else {
            this.securityChannel = -1;
        }
    }

    protected CompoundNBT getOrCreateInfo(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("Info")) {
            return tagCompound.func_74775_l("Info");
        }
        CompoundNBT data = new CompoundNBT();
        tagCompound.func_218657_a("Info", (INBT)data);
        return data;
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeCaps(tagCompound);
        this.writeInfo(tagCompound);
        return tagCompound;
    }

    protected void writeCaps(CompoundNBT tagCompound) {
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        this.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> infoTag.func_74768_a("infused", h.getInfused()));
        this.writeItemHandlerCap(tagCompound);
        this.writeEnergyCap(tagCompound);
    }

    protected void writeItemHandlerCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> tagCompound.func_218657_a("Items", h.serializeNBT()));
    }

    protected void writeEnergyCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityEnergy.ENERGY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> tagCompound.func_218657_a("Energy", h.serializeNBT()));
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        if (this.powerLevel > 0) {
            infoTag.func_74774_a("powered", (byte)this.powerLevel);
        }
        if (this.needsRedstoneMode()) {
            infoTag.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        }
        infoTag.func_74778_a("owner", this.ownerName);
        if (this.ownerUUID != null) {
            infoTag.func_186854_a("ownerId", this.ownerUUID);
        }
        if (this.securityChannel != -1) {
            infoTag.func_74768_a("secChannel", this.securityChannel);
        }
    }

    public boolean setOwner(PlayerEntity player) {
        if (!((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            return false;
        }
        if (this.ownerUUID != null) {
            return false;
        }
        this.ownerUUID = player.func_146103_bH().getId();
        this.ownerName = player.func_200200_C_().func_150254_d();
        this.markDirtyClient();
        return true;
    }

    public void clearOwner() {
        if (!((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            return;
        }
        this.ownerUUID = null;
        this.ownerName = "";
        this.securityChannel = -1;
        this.markDirtyClient();
    }

    public void setSecurityChannel(int id) {
        this.securityChannel = id;
        this.markDirtyClient();
    }

    public int getSecurityChannel() {
        return this.securityChannel;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        return Collections.emptyList();
    }

    @Override
    public TypedMap executeWithResult(String command, TypedMap args) {
        return null;
    }

    @Override
    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        return false;
    }

    @Override
    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        return false;
    }

    public boolean checkAccess(PlayerEntity player) {
        return false;
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return -1;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockReader world, BlockPos pos, BlockState metadata, int fortune) {
    }

    public void rotateBlock(Rotation axis) {
    }

    public boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        return false;
    }

    private <V> Consumer<V> findSetter(Key<V> key) {
        for (IValue<?> value : this.getValues()) {
            if (!key.getName().equals(value.getKey().getName())) continue;
            return value.setter();
        }
        return null;
    }

    private Runnable findConsumer(String key) {
        for (IAction action : this.getActions()) {
            if (!key.equals(action.getKey())) continue;
            return action.consumer();
        }
        return null;
    }

    public DimensionType getDimensionType() {
        return this.field_145850_b.func_201675_m().func_186058_p();
    }

    public <T> void valueToServer(SimpleChannel network, Key<T> valueKey, T value) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.func_174877_v(), this.getDimensionType(), COMMAND_SYNC_BINDING, TypedMap.builder().put(valueKey, value).build()));
    }

    public void requestDataFromServer(SimpleChannel channel, String command, @Nonnull TypedMap params) {
        channel.sendToServer((Object)new PacketRequestDataFromServer(this.getDimensionType(), this.field_174879_c, command, params, false));
    }

    @Override
    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        if (COMMAND_SYNC_BINDING.equals(command)) {
            this.syncBinding(params);
            return true;
        }
        if (COMMAND_SYNC_ACTION.equals(command)) {
            String key = params.get(PARAM_KEY);
            this.findConsumer(key).run();
            return true;
        }
        return false;
    }

    private <T> void syncBindingHelper(TypedMap params, Key<T> bkey) {
        T o = params.get(bkey);
        this.findSetter(bkey).accept(o);
    }

    private void syncBinding(TypedMap params) {
        for (Key<?> key : params.getKeys()) {
            this.syncBindingHelper(params, key);
        }
        this.markDirtyClient();
    }
}

