/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendServerCommand {
    String modid;
    String command;
    TypedMap arguments;

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.modid);
        buf.func_180714_a(this.command);
        TypedMapTools.writeArguments(buf, this.arguments);
    }

    public PacketSendServerCommand(PacketBuffer buf) {
        this.modid = buf.func_150789_c(Short.MAX_VALUE);
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.arguments = TypedMapTools.readArguments(buf);
    }

    public PacketSendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        this.modid = modid;
        this.command = command;
        this.arguments = arguments;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            boolean result = McJtyLib.handleCommand(this.modid, this.command, (PlayerEntity)ctx.getSender(), this.arguments);
            if (!result) {
                Logging.logError("Error handling command '" + this.command + "' for mod '" + this.modid + "'!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

