/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.MavenCoordinateResolver;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModListHandler;
import net.minecraftforge.forgespi.locating.IModFile;

public class MavenDirectoryLocator
extends AbstractJarFileLocator {
    private List<Path> modCoords;

    public List<IModFile> scanMods() {
        return this.modCoords.stream().map(mc -> new ModFile((Path)mc, this)).peek(f -> this.modJars.compute(f, (mf, fs) -> this.createFileSystem((IModFile)mf))).collect(Collectors.toList());
    }

    public String name() {
        return "maven libs";
    }

    public String toString() {
        return "{Maven Directory locator for mods " + this.modCoords + "}";
    }

    public void initArguments(Map<String, ?> arguments) {
        List mavenRoots = (List)arguments.get("mavenRoots");
        List<Path> mavenRootPaths = mavenRoots.stream().map(n -> FMLPaths.GAMEDIR.get().resolve((String)n)).collect(Collectors.toList());
        List mods = (List)arguments.get("mods");
        List<String> listedMods = ModListHandler.processModLists((List)arguments.get("modLists"), mavenRootPaths);
        List localModCoords = Stream.concat(mods.stream(), listedMods.stream()).map(MavenCoordinateResolver::get).collect(Collectors.toList());
        this.modCoords = localModCoords.stream().map(mc -> mavenRootPaths.stream().map(root -> root.resolve((Path)mc)).filter(path -> Files.exists(path, new LinkOption[0])).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to locate requested mod coordinate " + mc))).collect(Collectors.toList());
    }
}

