/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.loading.StringUtils;

public enum InvalidModIdentifier {
    OLDFORGE(InvalidModIdentifier.filePresent("mcmod.info")),
    FABRIC(InvalidModIdentifier.filePresent("fabric.mod.json")),
    LITELOADER(InvalidModIdentifier.filePresent("litemod.json")),
    OPTIFINE(InvalidModIdentifier.filePresent("optifine/Installer.class")),
    INVALIDZIP((f, zf) -> !zf.isPresent());

    private BiPredicate<Path, Optional<ZipFile>> ident;

    private InvalidModIdentifier(BiPredicate<Path, Optional<ZipFile>> identifier) {
        this.ident = identifier;
    }

    private String getReason() {
        return "fml.modloading.brokenfile." + StringUtils.toLowerCase(this.name());
    }

    public static Optional<String> identifyJarProblem(Path path) {
        Optional zfo = InvalidModIdentifier.optionalFromException(() -> new ZipFile(path.toFile()));
        Optional<String> result = Arrays.stream(InvalidModIdentifier.values()).filter(i -> i.ident.test(path, zfo)).map(InvalidModIdentifier::getReason).findAny();
        zfo.ifPresent(LamdbaExceptionUtils.rethrowConsumer(ZipFile::close));
        return result;
    }

    private static BiPredicate<Path, Optional<ZipFile>> filePresent(String filename) {
        return (f, zfo) -> zfo.map(zf -> zf.getEntry(filename) != null).orElse(false);
    }

    private static <T> Optional<T> optionalFromException(LamdbaExceptionUtils.Supplier_WithExceptions<T, ? extends Exception> supp) {
        try {
            return Optional.of(supp.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

