/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.ArrayList;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.screen.InventoryButtonReturnConfirmScreen;
import net.blay09.mods.waystones.client.gui.widget.WaystoneInventoryButton;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.InventoryButtonMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="waystones", value={Dist.CLIENT})
public class InventoryButtonGuiHandler {
    private static WaystoneInventoryButton buttonWarp;

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!(event.getGui() instanceof InventoryScreen)) {
            return;
        }
        InventoryButtonMode inventoryButtonMode = WaystoneConfig.getInventoryButtonMode();
        if (!inventoryButtonMode.isEnabled()) {
            return;
        }
        buttonWarp = new WaystoneInventoryButton((ContainerScreen)event.getGui(), button -> {
            Minecraft mc = event.getGui().getMinecraft();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player.field_71075_bZ.field_75098_d) {
                PlayerWaystoneManager.setInventoryButtonCooldownUntil((PlayerEntity)player, 0L);
            }
            if (PlayerWaystoneManager.canUseInventoryButton((PlayerEntity)player)) {
                if (inventoryButtonMode.hasNamedTarget()) {
                    mc.func_147108_a((Screen)new InventoryButtonReturnConfirmScreen(inventoryButtonMode.getNamedTarget()));
                } else if (inventoryButtonMode.isReturnToNearest()) {
                    if (PlayerWaystoneManager.getNearestWaystone((PlayerEntity)player) != null) {
                        mc.func_147108_a((Screen)new InventoryButtonReturnConfirmScreen());
                    }
                } else if (inventoryButtonMode.isReturnToAny()) {
                    NetworkHandler.channel.sendToServer((Object)new InventoryButtonMessage());
                }
            } else {
                mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.5f));
            }
        });
        event.addWidget((Widget)buttonWarp);
    }

    @SubscribeEvent
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof InventoryScreen && buttonWarp != null && buttonWarp.isHovered()) {
            InventoryButtonMode inventoryButtonMode = WaystoneConfig.getInventoryButtonMode();
            ArrayList<String> tooltip = new ArrayList<String>();
            long timeLeft = PlayerWaystoneManager.getInventoryButtonCooldownLeft((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            int secondsLeft = (int)(timeLeft / 1000L);
            if (inventoryButtonMode.hasNamedTarget()) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones.inventory.return_to_waystone", (Object[])new Object[0]));
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones.bound_to", (Object[])new Object[]{TextFormatting.DARK_AQUA + inventoryButtonMode.getNamedTarget()}));
                if (secondsLeft > 0) {
                    tooltip.add("");
                }
            } else if (inventoryButtonMode.isReturnToNearest()) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones.inventory.return_to_nearest_waystone", (Object[])new Object[0]));
                IWaystone nearestWaystone = PlayerWaystoneManager.getNearestWaystone((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                if (nearestWaystone != null) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones.bound_to", (Object[])new Object[]{TextFormatting.DARK_AQUA + nearestWaystone.getName()}));
                } else {
                    tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.waystones.inventory.no_waystones_activated", (Object[])new Object[0]));
                }
                if (secondsLeft > 0) {
                    tooltip.add("");
                }
            } else if (inventoryButtonMode.isReturnToAny()) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones.inventory.return_to_waystone", (Object[])new Object[0]));
                if (PlayerWaystoneManager.getWaystones((PlayerEntity)Minecraft.func_71410_x().field_71439_g).isEmpty()) {
                    tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.waystones.inventory.no_waystones_activated", (Object[])new Object[0]));
                }
            }
            if (secondsLeft > 0) {
                tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.waystones.cooldown_left", (Object[])new Object[]{secondsLeft}));
            }
            event.getGui().renderTooltip(tooltip, event.getMouseX(), event.getMouseY());
        }
    }
}

