/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import slimeknights.mantle.util.RecipeMatch;

public class RecipeMatchRegistry {
    protected final PriorityQueue<RecipeMatch> items = new PriorityQueue<RecipeMatch>(1, RecipeComparator.INSTANCE);

    public Optional<RecipeMatch.Match> matches(ItemStack ... stacks) {
        NonNullList nonNullStacks = NonNullList.func_191197_a((int)stacks.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i].func_190926_b()) continue;
            nonNullStacks.set(i, (Object)stacks[i].func_77946_l());
        }
        return this.matches((NonNullList<ItemStack>)nonNullStacks);
    }

    public Optional<RecipeMatch.Match> matches(NonNullList<ItemStack> stacks) {
        for (RecipeMatch recipe : this.items) {
            Optional<RecipeMatch.Match> match = recipe.matches(stacks);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    public Optional<RecipeMatch.Match> matches(NonNullList<ItemStack> stacks, int minAmount) {
        Optional<RecipeMatch.Match> matchOptional;
        int sum;
        RecipeMatch.Match match;
        stacks = RecipeMatchRegistry.copyItemStackArray(stacks);
        LinkedList matches = Lists.newLinkedList();
        for (sum = 0; sum < minAmount && (matchOptional = this.matches(stacks)).isPresent(); sum += match.amount) {
            match = matchOptional.get();
            matches.add(match);
            RecipeMatch.removeMatch(stacks, match);
        }
        if (sum < minAmount) {
            return Optional.empty();
        }
        LinkedList foundStacks = Lists.newLinkedList();
        for (RecipeMatch.Match m : matches) {
            foundStacks.addAll(m.stacks);
        }
        return Optional.of(new RecipeMatch.Match(foundStacks, sum));
    }

    public Optional<RecipeMatch.Match> matchesRecursively(NonNullList<ItemStack> stacks) {
        Optional<RecipeMatch.Match> matchOptional;
        stacks = RecipeMatchRegistry.copyItemStackArray(stacks);
        LinkedList matches = Lists.newLinkedList();
        int sum = 0;
        while ((matchOptional = this.matches(stacks)).isPresent()) {
            RecipeMatch.Match match = matchOptional.get();
            matches.add(match);
            RecipeMatch.removeMatch(stacks, match);
            sum += match.amount;
        }
        LinkedList foundStacks = Lists.newLinkedList();
        for (RecipeMatch.Match m : matches) {
            foundStacks.addAll(m.stacks);
        }
        return Optional.of(new RecipeMatch.Match(foundStacks, sum));
    }

    public void addItem(Block block, int amountMatched) {
        this.items.add(new RecipeMatch.Item(new ItemStack((IItemProvider)block), 1, amountMatched));
    }

    public void addItem(Item item, int amountNeeded, int amountMatched) {
        this.items.add(new RecipeMatch.Item(new ItemStack((IItemProvider)item), amountNeeded, amountMatched));
    }

    public void addItem(ItemStack item, int amountNeeded, int amountMatched) {
        this.items.add(new RecipeMatch.Item(item, amountNeeded, amountMatched));
    }

    public void addItem(Item item) {
        this.addItem(item, 1, 1);
    }

    public void addRecipeMatch(RecipeMatch match) {
        this.items.add(match);
    }

    public static NonNullList<ItemStack> copyItemStackArray(NonNullList<ItemStack> in) {
        NonNullList stacksCopy = NonNullList.func_191197_a((int)in.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < in.size(); ++i) {
            if (((ItemStack)in.get(i)).func_190926_b()) continue;
            stacksCopy.set(i, (Object)((ItemStack)in.get(i)).func_77946_l());
        }
        return stacksCopy;
    }

    private static class RecipeComparator
    implements Comparator<RecipeMatch> {
        public static RecipeComparator INSTANCE = new RecipeComparator();

        private RecipeComparator() {
        }

        @Override
        public int compare(RecipeMatch o1, RecipeMatch o2) {
            return o2.amountMatched - o1.amountMatched;
        }
    }
}

