/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.pulsar.flightpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IGenericEvent;
import slimeknights.mantle.pulsar.flightpath.Airdrop;
import slimeknights.mantle.pulsar.flightpath.IExceptionHandler;
import slimeknights.mantle.pulsar.flightpath.ISubscriberLocator;
import slimeknights.mantle.pulsar.flightpath.lib.AnnotationLocator;
import slimeknights.mantle.pulsar.flightpath.lib.BlackholeExceptionHandler;

@ParametersAreNonnullByDefault
public class Flightpath {
    private final ISubscriberLocator locator;
    private final LinkedHashMap<Object, Map<Class<?>, Map<Method, Type>>> subscribers = new LinkedHashMap();
    private final Object lock = new Object();
    private IExceptionHandler exceptionHandler = new BlackholeExceptionHandler();

    public Flightpath() {
        this.locator = new AnnotationLocator(Airdrop.class);
    }

    public Flightpath(ISubscriberLocator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionHandler(IExceptionHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            this.exceptionHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            if (this.subscribers.containsKey(obj)) {
                return;
            }
            this.subscribers.put(obj, this.locator.findSubscribers(obj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Event evt) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<Object, Map<Class<?>, Map<Method, Type>>> ent : this.subscribers.entrySet()) {
                for (Map.Entry<Class<?>, Map<Method, Type>> obj : ent.getValue().entrySet()) {
                    if (!obj.getKey().isAssignableFrom(evt.getClass())) continue;
                    for (Map.Entry<Method, Type> objEnt : obj.getValue().entrySet()) {
                        Method m = objEnt.getKey();
                        Type filter = objEnt.getValue();
                        try {
                            if (filter != null && filter != ((IGenericEvent)evt).getGenericType()) continue;
                            boolean access = m.isAccessible();
                            m.setAccessible(true);
                            m.invoke(ent.getKey(), evt);
                            m.setAccessible(access);
                        }
                        catch (InvocationTargetException ex) {
                            if (ex.getTargetException() instanceof Exception) {
                                this.exceptionHandler.handle((Exception)ex.getTargetException());
                                continue;
                            }
                            this.exceptionHandler.handle(ex);
                        }
                        catch (Exception ex) {
                            this.exceptionHandler.handle(ex);
                        }
                    }
                }
            }
            this.exceptionHandler.flush();
        }
    }
}

