/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;

@OnlyIn(value=Dist.CLIENT)
public class BookScreen
extends Screen {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static int PAGE_MARGIN = 8;
    public static int PAGE_PADDING_TOP = 4;
    public static int PAGE_PADDING_BOT = 4;
    public static int PAGE_PADDING_LEFT = 8;
    public static int PAGE_PADDING_RIGHT = 0;
    public static float PAGE_SCALE = 1.0f;
    public static int PAGE_WIDTH_UNSCALED = 206;
    public static int PAGE_HEIGHT_UNSCALED = 200;
    public static int PAGE_WIDTH;
    public static int PAGE_HEIGHT;
    private ArrowButton previousArrow;
    private ArrowButton nextArrow;
    private ArrowButton backArrow;
    private ArrowButton indexArrow;
    public final BookData book;
    private ItemStack item;
    private int page = -1;
    private int oldPage = -2;
    private ArrayList<BookElement> leftElements = new ArrayList();
    private ArrayList<BookElement> rightElements = new ArrayList();
    public AdvancementCache advancementCache;

    public static void initWidthsAndHeights() {
        PAGE_WIDTH = (int)((float)(PAGE_WIDTH_UNSCALED - (PAGE_PADDING_LEFT + PAGE_PADDING_RIGHT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
        PAGE_HEIGHT = (int)((float)(PAGE_HEIGHT_UNSCALED - (PAGE_PADDING_TOP + PAGE_PADDING_BOT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
    }

    public BookScreen(ITextComponent title, BookData book, @Nullable ItemStack item) {
        super(title);
        this.book = book;
        this.item = item;
        this.minecraft = Minecraft.func_71410_x();
        this.font = this.minecraft.field_71466_p;
        BookScreen.initWidthsAndHeights();
        this.advancementCache = new AdvancementCache();
        this.minecraft.field_71439_g.field_71174_a.func_191982_f().func_192798_a((ClientAdvancementManager.IListener)this.advancementCache);
        this.openPage(book.findPageNumber(BookHelper.getSavedPage(item), this.advancementCache));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        BookScreen.initWidthsAndHeights();
        FontRenderer fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = this.minecraft.field_71466_p;
        }
        if (debug) {
            int n = fontRenderer.func_78256_a("DEBUG") + 4;
            fontRenderer.getClass();
            BookScreen.fill((int)0, (int)0, (int)n, (int)(9 + 4), (int)0x55000000);
            fontRenderer.func_211126_b("DEBUG", 2.0f, 2.0f, -1);
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        float coverR = (float)(this.book.appearance.coverColor >> 16 & 0xFF) / 255.0f;
        float coverG = (float)(this.book.appearance.coverColor >> 8 & 0xFF) / 255.0f;
        float coverB = (float)(this.book.appearance.coverColor & 0xFF) / 255.0f;
        TextureManager render = this.minecraft.field_71446_o;
        if (this.page == -1) {
            render.func_110577_a(Textures.TEX_BOOKFRONT);
            RenderHelper.func_74518_a();
            RenderSystem.color3f((float)coverR, (float)coverG, (float)coverB);
            BookScreen.blit((int)(this.width / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.book.appearance.title.isEmpty()) {
                BookScreen.blit((int)(this.width / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
                RenderSystem.pushMatrix();
                float scale = fontRenderer.func_78256_a(this.book.appearance.title) <= 67 ? 2.5f : 2.0f;
                RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
                String string = this.book.appearance.title;
                float f = (float)(this.width / 2) / scale + 3.0f - (float)(fontRenderer.func_78256_a(this.book.appearance.title) / 2);
                int n = this.height / 2;
                fontRenderer.getClass();
                fontRenderer.func_175063_a(string, f, (float)(n - 9 / 2) / scale - 4.0f, 11436032);
                RenderSystem.popMatrix();
            }
            if (!this.book.appearance.subtitle.isEmpty()) {
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.0f);
                String string = this.book.appearance.subtitle;
                float f = (float)(this.width / 2) / 1.5f + 7.0f - (float)(fontRenderer.func_78256_a(this.book.appearance.subtitle) / 2);
                int n = this.height / 2 + 100;
                fontRenderer.getClass();
                fontRenderer.func_175063_a(string, f, (float)(n - 9 * 2) / 1.5f, 11436032);
                RenderSystem.popMatrix();
            }
        } else {
            render.func_110577_a(Textures.TEX_BOOK);
            RenderHelper.func_74518_a();
            RenderSystem.color3f((float)coverR, (float)coverG, (float)coverB);
            BookScreen.blit((int)(this.width / 2 - PAGE_WIDTH_UNSCALED), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)(PAGE_WIDTH_UNSCALED * 2), (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.page != 0) {
                BookElement element;
                int i;
                BookScreen.blit((int)(this.width / 2 - PAGE_WIDTH_UNSCALED), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
                RenderSystem.pushMatrix();
                this.drawerTransform(false);
                RenderSystem.scalef((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 2 + "";
                    fontRenderer.func_211126_b(pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.func_78256_a(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406);
                }
                int mX = this.getMouseX(false);
                int mY = this.getMouseY();
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(mX, mY, partialTicks, fontRenderer);
                }
                RenderSystem.popMatrix();
            }
            render.func_110577_a(Textures.TEX_BOOK);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page < fullPageCount - 1 || this.book.getPageCount(this.advancementCache) % 2 != 0) {
                BookElement element;
                int i;
                BookScreen.blit((int)(this.width / 2), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)PAGE_WIDTH_UNSCALED, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
                RenderSystem.pushMatrix();
                this.drawerTransform(true);
                RenderSystem.scalef((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 3 + "";
                    fontRenderer.func_211126_b(pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.func_78256_a(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406);
                }
                int mX = this.getMouseX(true);
                int mY = this.getMouseY();
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(mX, mY, partialTicks, fontRenderer);
                }
                RenderSystem.popMatrix();
            }
        }
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        this.children.clear();
        this.previousArrow = (ArrowButton)this.addButton((Widget)new ArrowButton(-50, -50, ArrowButton.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.nextArrow = (ArrowButton)this.addButton((Widget)new ArrowButton(-50, -50, ArrowButton.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.backArrow = (ArrowButton)this.addButton((Widget)new ArrowButton(this.width / 2 - 9, this.height / 2 + 5 + PAGE_HEIGHT / 2, ArrowButton.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.indexArrow = (ArrowButton)this.addButton((Widget)new ArrowButton(this.width / 2 - PAGE_WIDTH_UNSCALED - 9, this.height / 2 - PAGE_HEIGHT_UNSCALED / 2, ArrowButton.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            this.openPage(this.book.findPageNumber("index.page1"));
            this.oldPage = -2;
            this.buildPages();
        }));
        this.buildPages();
    }

    public void tick() {
        super.tick();
        this.previousArrow.visible = this.page != -1;
        this.nextArrow.visible = this.page + 1 < this.book.getFullPageCount(this.advancementCache);
        boolean bl = this.backArrow.visible = this.oldPage >= -1;
        if (this.page == -1) {
            this.nextArrow.x = this.width / 2 + 80;
            this.indexArrow.visible = false;
        } else {
            this.previousArrow.x = this.width / 2 - 184;
            this.nextArrow.x = this.width / 2 + 165;
            this.indexArrow.visible = this.book.findSection("index") != null && (this.page - 1) * 2 + 2 > this.book.findSection("index").getPageCount();
        }
        this.previousArrow.y = this.height / 2 + 75;
        this.nextArrow.y = this.height / 2 + 75;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        switch (keyCode) {
            case 65: 
            case 263: {
                --this.page;
                if (this.page < -1) {
                    this.page = -1;
                }
                this.oldPage = -2;
                this.buildPages();
                return true;
            }
            case 68: 
            case 262: {
                ++this.page;
                int fullPageCount = this.book.getFullPageCount(this.advancementCache);
                if (this.page >= fullPageCount) {
                    this.page = fullPageCount - 1;
                }
                this.oldPage = -2;
                this.buildPages();
                return true;
            }
            case 292: {
                debug = !debug;
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double unKnown1, double unKnown2, double scrollDelta) {
        if (scrollDelta < 0.0) {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
            return true;
        }
        if (scrollDelta > 0.0) {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
            return true;
        }
        return super.mouseScrolled(scrollDelta, unKnown1, unKnown2);
    }

    public boolean mouseClicked(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > (double)((float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE)) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int oldPage = this.page;
        ImmutableList elementList = ImmutableList.copyOf(right ? this.rightElements : this.leftElements);
        for (BookElement element : elementList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.page == oldPage) continue;
            return true;
        }
        return super.mouseClicked(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean mouseReleased(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > (double)((float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE)) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseReleased(mouseX, mouseY, mouseButton);
            ++i;
        }
        return super.mouseReleased(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLaslick, double unknown) {
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if (mouseX > (double)((float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE)) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseClickMove(mouseX, mouseY, clickedMouseButton);
            ++i;
        }
        return true;
    }

    public void removed() {
        PageData page;
        if (this.minecraft.field_71439_g == null) {
            return;
        }
        PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.advancementCache) : this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
        if (page == null) {
            page = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
        }
        if (this.page == -1) {
            BookLoader.updateSavedPage((PlayerEntity)this.minecraft.field_71439_g, this.item, "");
        } else if (page != null && page.parent != null) {
            BookLoader.updateSavedPage((PlayerEntity)this.minecraft.field_71439_g, this.item, page.parent.name + "." + page.name);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawerTransform(boolean rightSide) {
        if (rightSide) {
            RenderSystem.translatef((float)(this.width / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN), (float)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        } else {
            RenderSystem.translatef((float)(this.width / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN), (float)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.width / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN;
        }
        return this.width / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN;
    }

    protected float topOffset() {
        return this.height / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN;
    }

    protected int getMouseX(boolean rightSide) {
        return (int)((Minecraft.func_71410_x().field_71417_B.func_198024_e() * (double)this.width / (double)this.minecraft.func_228018_at_().func_198109_k() - (double)this.leftOffset(rightSide)) / (double)PAGE_SCALE);
    }

    protected int getMouseY() {
        return (int)((Minecraft.func_71410_x().field_71417_B.func_198026_f() * (double)this.height / (double)this.minecraft.func_228018_at_().func_198091_l() - 1.0 - (double)this.topOffset()) / (double)PAGE_SCALE);
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.advancementCache)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public ArrayList<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : null);
    }

    public void openCover() {
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    public void itemClicked(ItemStack item) {
        StringActionProcessor.process(this.book.getItemAction(ItemStackData.getItemStackData(item, true)), this);
    }

    private void buildPages() {
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.advancementCache);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    static {
        BookScreen.initWidthsAndHeights();
    }

    public class AdvancementCache
    implements ClientAdvancementManager.IListener {
        private HashMap<Advancement, AdvancementProgress> progress = new HashMap();
        private HashMap<ResourceLocation, Advancement> nameCache = new HashMap();

        public AdvancementProgress getProgress(String id) {
            return this.getProgress(this.getAdvancement(id));
        }

        public AdvancementProgress getProgress(Advancement advancement) {
            return this.progress.get(advancement);
        }

        public Advancement getAdvancement(String id) {
            return this.nameCache.get(new ResourceLocation(id));
        }

        public void func_191933_a(Advancement advancement, AdvancementProgress advancementProgress) {
            this.progress.put(advancement, advancementProgress);
        }

        public void func_193982_e(@Nullable Advancement advancement) {
        }

        public void func_191931_a(Advancement advancement) {
            this.nameCache.put(advancement.func_192067_g(), advancement);
        }

        public void func_191928_b(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.func_192067_g());
        }

        public void func_191932_c(Advancement advancement) {
            this.nameCache.put(advancement.func_192067_g(), advancement);
        }

        public void func_191929_d(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.func_192067_g());
        }

        public void func_191930_a() {
            this.progress.clear();
            this.nameCache.clear();
        }
    }
}

