/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainer;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleScreen<CONTAINER extends MultiModuleContainer<?>>
extends ContainerScreen<CONTAINER> {
    protected List<ModuleScreen> modules = Lists.newArrayList();
    public int cornerX;
    public int cornerY;
    public int realWidth = -1;
    public int realHeight = -1;

    public MultiModuleScreen(CONTAINER container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.passEvents = true;
    }

    protected void addModule(ModuleScreen module) {
        this.modules.add(module);
    }

    public List<Rectangle2d> getModuleAreas() {
        ArrayList<Rectangle2d> areas = new ArrayList<Rectangle2d>(this.modules.size());
        for (ModuleScreen module : this.modules) {
            areas.add(module.getArea());
        }
        return areas;
    }

    public void init() {
        if (this.realWidth > -1) {
            this.field_146999_f = this.realWidth;
            this.field_147000_g = this.realHeight;
        }
        super.init();
        this.cornerX = this.field_147003_i;
        this.cornerY = this.field_147009_r;
        this.realWidth = this.field_146999_f;
        this.realHeight = this.field_147000_g;
        for (ModuleScreen module : this.modules) {
            this.updateSubmodule(module);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        for (ModuleScreen module : this.modules) {
            module.handleDrawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawContainerName();
        this.drawPlayerInventoryName();
        for (ModuleScreen module : this.modules) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
            RenderSystem.translatef((float)module.field_147003_i, (float)module.field_147009_r, (float)0.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            module.handleDrawGuiContainerForegroundLayer(mouseX, mouseY);
            RenderSystem.popMatrix();
        }
    }

    protected void drawBackground(ResourceLocation background) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(background);
        this.blit(this.cornerX, this.cornerY, 0, 0, this.realWidth, this.realHeight);
    }

    protected void drawContainerName() {
        String localizedName = this.getTitle().func_150254_d();
        if (localizedName != null) {
            this.font.func_211126_b(localizedName, 8.0f, 6.0f, 0x404040);
        }
    }

    protected void drawPlayerInventoryName() {
        String localizedName = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150261_e();
        this.font.func_211126_b(localizedName, 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        for (ModuleScreen module : this.modules) {
            module.init(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void resize(@Nonnull Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        for (ModuleScreen module : this.modules) {
            module.resize(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        int oldX = this.field_147003_i;
        int oldY = this.field_147009_r;
        int oldW = this.field_146999_f;
        int oldH = this.field_147000_g;
        this.field_147003_i = this.cornerX;
        this.field_147009_r = this.cornerY;
        this.field_146999_f = this.realWidth;
        this.field_147000_g = this.realHeight;
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.field_147003_i = oldX;
        this.field_147009_r = oldY;
        this.field_146999_f = oldW;
        this.field_147000_g = oldH;
    }

    protected boolean func_195359_a(int left, int top, int right, int bottom, double pointX, double pointY) {
        return (pointX -= (double)this.cornerX) >= (double)(left - 1) && pointX < (double)(left + right + 1) && (pointY -= (double)this.cornerY) >= (double)(top - 1) && pointY < (double)(top + bottom + 1);
    }

    protected void updateSubmodule(ModuleScreen module) {
        module.updatePosition(this.cornerX, this.cornerY, this.realWidth, this.realHeight);
        if (module.field_147003_i < this.field_147003_i) {
            this.field_146999_f += this.field_147003_i - module.field_147003_i;
            this.field_147003_i = module.field_147003_i;
        }
        if (module.field_147009_r < this.field_147009_r) {
            this.field_147000_g += this.field_147009_r - module.field_147009_r;
            this.field_147009_r = module.field_147009_r;
        }
        if (module.guiRight() > this.field_147003_i + this.field_146999_f) {
            this.field_146999_f = module.guiRight() - this.field_147003_i;
        }
        if (module.guiBottom() > this.field_147009_r + this.field_147000_g) {
            this.field_147000_g = module.guiBottom() - this.field_147009_r;
        }
    }

    public void func_146977_a(Slot slotIn) {
        ModuleScreen module = this.getModuleForSlot(slotIn.field_75222_d);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return;
            }
        }
        if (slotIn instanceof WrapperSlot) {
            slotIn.field_75223_e = ((WrapperSlot)slotIn).parent.field_75223_e;
            slotIn.field_75221_f = ((WrapperSlot)slotIn).parent.field_75221_f;
        }
        super.func_146977_a(slotIn);
    }

    public boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        ModuleScreen module = this.getModuleForSlot(slotIn.field_75222_d);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return false;
            }
        }
        return super.func_195362_a(slotIn, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        ModuleScreen module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        ModuleScreen module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        ModuleScreen module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        ModuleScreen module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.mouseReleased(mouseX, mouseY, state);
    }

    protected ModuleScreen getModuleForPoint(double x, double y) {
        for (ModuleScreen module : this.modules) {
            if (!this.func_195359_a(module.field_147003_i, module.field_147009_r, module.guiRight(), module.guiBottom(), x + (double)this.cornerX, y + (double)this.cornerY)) continue;
            return module;
        }
        return null;
    }

    protected ModuleScreen getModuleForSlot(int slotNumber) {
        return this.getModuleForContainer(((MultiModuleContainer)((Object)this.getContainer())).getSlotContainer(slotNumber));
    }

    protected ModuleScreen getModuleForContainer(Container container) {
        for (ModuleScreen module : this.modules) {
            if (module.func_212873_a_() != container) continue;
            return module;
        }
        return null;
    }

    @Nonnull
    public CONTAINER getContainer() {
        return (CONTAINER)((Object)((MultiModuleContainer)this.field_147002_h));
    }
}

