/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public class TRSRBakedModel
implements IBakedModel {
    protected final IBakedModel original;
    protected final TransformationMatrix transformation;
    private final TRSROverride override;
    private final int faceOffset;

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new TransformationMatrix(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), TransformationHelper.quatFromXYZ((float[])new float[]{rotX, rotY, rotZ}, (boolean)false)));
    }

    public TRSRBakedModel(IBakedModel original, TransformationMatrix transform) {
        this.original = original;
        this.transformation = transform.blockCenterToCorner();
        this.override = new TRSROverride(this);
        this.faceOffset = 0;
    }

    public TRSRBakedModel(IBakedModel original, Direction facing) {
        this.original = original;
        this.override = new TRSROverride(this);
        this.faceOffset = 4 + Direction.NORTH.func_176736_b() - facing.func_176736_b();
        double r = Math.PI * (double)(360 - facing.func_176734_d().func_176736_b() * 90) / 180.0;
        this.transformation = new TransformationMatrix(null, null, null, TransformationHelper.quatFromXYZ((float[])new float[]{0.0f, (float)r, 0.0f}, (boolean)false)).blockCenterToCorner();
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!this.original.func_188618_c()) {
            try {
                if (side != null && side.func_176736_b() > -1) {
                    side = Direction.func_176731_b((int)((side.func_176736_b() + this.faceOffset) % 4));
                }
                for (BakedQuad quad : this.original.func_200117_a(state, side, rand)) {
                    Transformer transformer = new Transformer(this.transformation, quad.func_187508_a());
                    quad.pipe((IVertexConsumer)transformer);
                    builder.add((Object)transformer.build());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.override;
    }

    private static class Transformer
    extends VertexTransformer {
        protected Matrix4f transformation;
        protected Matrix3f normalTransformation;

        public Transformer(TransformationMatrix transformation, TextureAtlasSprite textureAtlasSprite) {
            super((IVertexConsumer)new BakedQuadBuilder(textureAtlasSprite));
            this.transformation = transformation.func_227988_c_();
            this.normalTransformation = new Matrix3f(this.transformation);
            this.normalTransformation.func_226123_f_();
            this.normalTransformation.func_226110_a_();
        }

        public void put(int element, float ... data) {
            VertexFormatElement.Usage usage = ((VertexFormatElement)this.parent.getVertexFormat().func_227894_c_().get(element)).func_177375_c();
            if (usage == VertexFormatElement.Usage.POSITION && data.length >= 3) {
                Vector4f vec = new Vector4f(data[0], data[1], data[2], 1.0f);
                vec.func_229372_a_(this.transformation);
                data = new float[]{vec.func_195910_a(), vec.func_195913_b(), vec.func_195914_c(), vec.func_195915_d()};
            } else if (usage == VertexFormatElement.Usage.NORMAL && data.length >= 3) {
                Vector3f vec = new Vector3f(data);
                vec.func_229188_a_(this.normalTransformation);
                vec.func_229194_d_();
                data = new float[4];
                data[0] = vec.func_195899_a();
                data[1] = vec.func_195900_b();
                data[2] = vec.func_195902_c();
            }
            super.put(element, data);
        }

        public BakedQuad build() {
            return ((BakedQuadBuilder)this.parent).build();
        }
    }

    private static class TRSROverride
    extends ItemOverrideList {
        private final TRSRBakedModel model;

        public TRSROverride(TRSRBakedModel model) {
            this.model = model;
        }

        @Nonnull
        public IBakedModel func_209581_a(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull LivingEntity entity) {
            IBakedModel baked = this.model.original.func_188617_f().func_209581_a(originalModel, stack, world, entity);
            return new TRSRBakedModel(baked, this.model.transformation);
        }
    }
}

