/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.logic.entityblocking.LightsRegistryCapability;

@Mod.EventBusSubscriber(modid="torchmaster")
public class EntityBlockingEventHandler {
    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) throws InterruptedException {
        event.getWorld().func_201672_e().func_217381_Z().func_76320_a("torchmaster_checkspawn");
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (((Boolean)TorchmasterConfig.GENERAL.blockOnlyNaturalSpawns.get()).booleanValue() && event.isSpawner()) {
            return;
        }
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> {
            if (reg.shouldBlockEntity(entity)) {
                event.setResult(Event.Result.DENY);
            }
        });
        event.getWorld().func_201672_e().func_217381_Z().func_76319_b();
    }

    @SubscribeEvent
    public static void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("torchmaster", "registry"), (ICapabilityProvider)new LightsRegistryCapability());
    }

    @SubscribeEvent
    public static void onGlobalTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (Torchmaster.server == null) {
                return;
            }
            for (ServerWorld world : Torchmaster.server.func_212370_w()) {
                world.func_217381_Z().func_76320_a("torchmaster_dim" + world.field_73011_w.func_186058_p().func_186068_a());
                world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> reg.onGlobalTick((World)world));
                world.func_217381_Z().func_76319_b();
            }
        }
    }
}

