/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.commands.TorchInfo;

public class CommandTorchmaster {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder command = Commands.func_197057_a((String)"torchmaster");
        for (SubCommands subCommand : SubCommands.values()) {
            command.then(Commands.func_197057_a((String)subCommand.getTranslationKey()).executes(subCommand::execute));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.requires(cmdSrc -> cmdSrc.func_197034_c(2))).executes(ctx -> 0));
    }

    public static enum SubCommands {
        DUMP_TORCHES("torchdump"){

            @Override
            public int execute(CommandContext<CommandSource> ctx) {
                CommandSource source = (CommandSource)ctx.getSource();
                MinecraftServer server = source.func_197028_i();
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Torch Dump Start  #");
                Torchmaster.Log.info("#################################");
                for (World world : server.func_212370_w()) {
                    world.getCapability(ModCaps.TEB_REGISTRY, Direction.DOWN).ifPresent(container -> {
                        Torchmaster.Log.info("Torches in dimension {} (Id: {}):", (Object)world.func_201675_m().func_186058_p().getRegistryName(), (Object)world.func_201675_m().func_186058_p().func_186068_a());
                        for (TorchInfo torch : container.getEntries()) {
                            Torchmaster.Log.info("  {} @ {}", (Object)torch.getName(), (Object)torch.getPos());
                        }
                    });
                }
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Torch Dump End    #");
                Torchmaster.Log.info("#################################");
                source.func_197030_a((ITextComponent)new TranslationTextComponent("torchmaster.command.torch_dump.completed", new Object[0]), false);
                return 0;
            }
        }
        ,
        DUMP_ENTITIES("entitydump"){

            @Override
            public int execute(CommandContext<CommandSource> ctx) {
                CommandSource source = (CommandSource)ctx.getSource();
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Entity Dump Start #");
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("List of registered entities:");
                for (ResourceLocation loc : ForgeRegistries.ENTITIES.getKeys()) {
                    Torchmaster.Log.info("  {}", (Object)loc);
                }
                Torchmaster.Log.info("Dread Lamp Registry Content:");
                for (ResourceLocation loc : Torchmaster.DreadLampFilterRegistry.getRegisteredEntities()) {
                    Torchmaster.Log.info("  {}", (Object)loc);
                }
                Torchmaster.Log.info("Mega Torch Registry Content:");
                for (ResourceLocation loc : Torchmaster.MegaTorchFilterRegistry.getRegisteredEntities()) {
                    Torchmaster.Log.info("  {}", (Object)loc);
                }
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Entity Dump End   #");
                Torchmaster.Log.info("#################################");
                source.func_197030_a((ITextComponent)new TranslationTextComponent("torchmaster.command.entity_dump.completed", new Object[0]), false);
                return 0;
            }
        };

        private final String translationKey;

        private SubCommands(String translationKey) {
            this.translationKey = translationKey;
        }

        public abstract int execute(CommandContext<CommandSource> var1);

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

