/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.util;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Mod;
import shadows.click.util.NetHandlerSpaghettiServer;

@Mod.EventBusSubscriber
public class FakePlayerUtil {
    private static final Map<World, Map<GameProfile, UsefulFakePlayer>> PLAYERS = new WeakHashMap<World, Map<GameProfile, UsefulFakePlayer>>();

    public static UsefulFakePlayer getPlayer(World world, GameProfile profile) {
        return PLAYERS.computeIfAbsent(world, p -> new HashMap()).computeIfAbsent(profile, p -> {
            UsefulFakePlayer player = new UsefulFakePlayer(world, profile);
            player.field_71135_a = new NetHandlerSpaghettiServer(player);
            return player;
        });
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, BlockPos pos, Direction direction, ItemStack toHold, boolean sneaking) {
        float pitch;
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)toHold);
        float f = direction == Direction.UP ? -90.0f : (pitch = direction == Direction.DOWN ? 90.0f : 0.0f);
        float yaw = direction == Direction.SOUTH ? 0.0f : (direction == Direction.WEST ? 90.0f : (direction == Direction.NORTH ? 180.0f : -90.0f));
        Vec3i sideVec = direction.func_176730_m();
        Direction.Axis a = direction.func_176740_k();
        Direction.AxisDirection ad = direction.func_176743_c();
        double x = a == Direction.Axis.X && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.func_177958_n() / 1.9;
        double y = 0.5 + (double)sideVec.func_177956_o() / 1.9;
        double z = a == Direction.Axis.Z && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.func_177952_p() / 1.9;
        player.func_70012_b((double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, yaw, pitch);
        if (!toHold.func_190926_b()) {
            player.func_110140_aT().func_111147_b(toHold.func_111283_C(EquipmentSlotType.MAINHAND));
        }
        player.func_226284_e_(sneaking);
    }

    public static void cleanupFakePlayerFromUse(UsefulFakePlayer player, ItemStack resultStack, ItemStack oldStack, Consumer<ItemStack> stackCallback) {
        if (!oldStack.func_190926_b()) {
            player.func_110140_aT().func_111148_a(oldStack.func_111283_C(EquipmentSlotType.MAINHAND));
        }
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
        stackCallback.accept(resultStack);
        if (!player.field_71071_by.func_191420_l()) {
            player.field_71071_by.func_70436_m();
        }
        player.func_226284_e_(false);
    }

    public static ItemStack rightClickInDirection(UsefulFakePlayer player, World world, BlockPos pos, Direction side, BlockState sourceState) {
        ActionResultType type;
        BlockPos blockpos;
        BlockState state;
        RayTraceResult toUse;
        Vec3d base = new Vec3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        Vec3d look = player.func_70040_Z();
        Vec3d target = base.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        BlockRayTraceResult trace = world.func_217299_a(new RayTraceContext(base, target, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        RayTraceResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, world);
        Object object = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.func_216347_e().func_72438_d(base);
            double d2 = traceEntity.func_216347_e().func_72438_d(base);
            Object object2 = toUse = traceEntity.func_216346_c() == RayTraceResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        if (toUse == null) {
            return player.func_184614_ca();
        }
        ItemStack itemstack = player.func_184614_ca();
        if (toUse.func_216346_c() == RayTraceResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityRayTraceResult)toUse).func_216348_a(), toUse, CUseEntityPacket.Action.INTERACT_AT)) {
                return player.func_184614_ca();
            }
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityRayTraceResult)toUse).func_216348_a(), null, CUseEntityPacket.Action.INTERACT)) {
                return player.func_184614_ca();
            }
        } else if (toUse.func_216346_c() == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(blockpos = ((BlockRayTraceResult)toUse).func_216350_a())) != sourceState && state.func_185904_a() != Material.field_151579_a && (type = player.field_71134_c.func_219441_a((PlayerEntity)player, world, itemstack, Hand.MAIN_HAND, (BlockRayTraceResult)toUse)) == ActionResultType.SUCCESS) {
            return player.func_184614_ca();
        }
        if (toUse == null || toUse.func_216346_c() == RayTraceResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.func_180495_p(pos.func_177967_a(side, i));
                if (state == sourceState || state.func_185904_a() == Material.field_151579_a) continue;
                player.field_71134_c.func_219441_a((PlayerEntity)player, world, itemstack, Hand.MAIN_HAND, (BlockRayTraceResult)toUse);
                return player.func_184614_ca();
            }
        }
        if (itemstack.func_190926_b() && (toUse == null || toUse.func_216346_c() == RayTraceResult.Type.MISS)) {
            ForgeHooks.onEmptyClick((PlayerEntity)player, (Hand)Hand.MAIN_HAND);
        }
        if (!itemstack.func_190926_b()) {
            player.field_71134_c.func_187250_a((PlayerEntity)player, world, itemstack, Hand.MAIN_HAND);
        }
        return player.func_184614_ca();
    }

    public static ItemStack leftClickInDirection(UsefulFakePlayer player, World world, BlockPos pos, Direction side, BlockState sourceState) {
        BlockPos blockpos;
        BlockState state;
        RayTraceResult toUse;
        Vec3d base = new Vec3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        Vec3d look = player.func_70040_Z();
        Vec3d target = base.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        BlockRayTraceResult trace = world.func_217299_a(new RayTraceContext(base, target, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        RayTraceResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, world);
        Object object = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.func_216347_e().func_72438_d(base);
            double d2 = traceEntity.func_216347_e().func_72438_d(base);
            Object object2 = toUse = traceEntity.func_216346_c() == RayTraceResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        if (toUse == null) {
            return player.func_184614_ca();
        }
        ItemStack itemstack = player.func_184614_ca();
        if (toUse.func_216346_c() == RayTraceResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityRayTraceResult)toUse).func_216348_a(), null, CUseEntityPacket.Action.ATTACK)) {
                return player.func_184614_ca();
            }
        } else if (toUse.func_216346_c() == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(blockpos = ((BlockRayTraceResult)toUse).func_216350_a())) != sourceState && state.func_185904_a() != Material.field_151579_a) {
            player.field_71134_c.func_225416_a(blockpos, CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, ((BlockRayTraceResult)toUse).func_216354_b(), player.field_71133_b.func_71207_Z());
            return player.func_184614_ca();
        }
        if (toUse == null || toUse.func_216346_c() == RayTraceResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.func_180495_p(pos.func_177967_a(side, i));
                if (state == sourceState || state.func_185904_a() == Material.field_151579_a) continue;
                player.field_71134_c.func_225416_a(pos.func_177967_a(side, i), CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, side.func_176734_d(), player.field_71133_b.func_71207_Z());
                return player.func_184614_ca();
            }
        }
        if (itemstack.func_190926_b() && (toUse == null || toUse.func_216346_c() == RayTraceResult.Type.MISS)) {
            ForgeHooks.onEmptyLeftClick((PlayerEntity)player);
        }
        return player.func_184614_ca();
    }

    public static RayTraceResult traceEntities(UsefulFakePlayer player, Vec3d base, Vec3d target, World world) {
        Entity pointedEntity = null;
        EntityRayTraceResult result = null;
        Vec3d vec3d3 = null;
        AxisAlignedBB search = new AxisAlignedBB(base.field_72450_a, base.field_72448_b, base.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c).func_72314_b(0.5, 0.5, 0.5);
        List list = world.func_175674_a((Entity)player, search, entity -> EntityPredicates.field_180132_d.test(entity) && entity != null && entity.func_70067_L());
        double d2 = 5.0;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB aabb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optVec = aabb.func_216365_b(base, target);
            if (aabb.func_72318_a(base)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = optVec.orElse(base);
                d2 = 0.0;
                continue;
            }
            if (!optVec.isPresent() || !((d3 = base.func_72438_d((Vec3d)optVec.get())) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == player.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = (Vec3d)optVec.get();
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = (Vec3d)optVec.get();
            d2 = d3;
        }
        if (pointedEntity != null && base.func_72438_d(vec3d3) > 5.0) {
            pointedEntity = null;
            result = BlockRayTraceResult.func_216352_a(vec3d3, null, (BlockPos)new BlockPos(vec3d3));
        }
        if (pointedEntity != null) {
            result = new EntityRayTraceResult(pointedEntity, vec3d3);
        }
        return result;
    }

    public static boolean processUseEntity(UsefulFakePlayer player, World world, Entity entity, @Nullable RayTraceResult result, CUseEntityPacket.Action action) {
        if (entity != null) {
            boolean flag = player.func_70685_l(entity);
            double d0 = 36.0;
            if (!flag) {
                d0 = 9.0;
            }
            if (player.func_70068_e(entity) < d0) {
                if (action == CUseEntityPacket.Action.INTERACT) {
                    return player.func_190775_a(entity, Hand.MAIN_HAND) == ActionResultType.SUCCESS;
                }
                if (action == CUseEntityPacket.Action.INTERACT_AT) {
                    if (ForgeHooks.onInteractEntityAt((PlayerEntity)player, (Entity)entity, (Vec3d)result.func_216347_e(), (Hand)Hand.MAIN_HAND) != null) {
                        return false;
                    }
                    return entity.func_184199_a((PlayerEntity)player, result.func_216347_e(), Hand.MAIN_HAND) == ActionResultType.SUCCESS;
                }
                if (action == CUseEntityPacket.Action.ATTACK) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity || entity instanceof ArrowEntity || entity == player) {
                        return false;
                    }
                    player.func_71059_n(entity);
                    return true;
                }
            }
        }
        return false;
    }

    public static RayTraceResult rayTrace(UsefulFakePlayer player, World world, double reachDist, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * reachDist, vec3d1.field_72448_b * reachDist, vec3d1.field_72449_c * reachDist);
        return world.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    public static class UsefulFakePlayer
    extends FakePlayer {
        public UsefulFakePlayer(World world, GameProfile name) {
            super((ServerWorld)world, name);
        }

        public float func_213307_e(Pose pose) {
            return 0.0f;
        }

        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }

        public float func_184825_o(float adjustTicks) {
            return 1.0f;
        }
    }
}

