/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.block;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.click.ClickMachine;
import shadows.click.ClickMachineConfig;
import shadows.click.block.BlockAutoClick;
import shadows.click.block.gui.ContainerAutoClick;
import shadows.click.net.MessageUpdateGui;
import shadows.click.util.FakePlayerUtil;
import shadows.placebo.util.NetworkUtils;

public class TileAutoClick
extends TileEntity
implements ITickableTileEntity,
Consumer<ItemStack>,
INamedContainerProvider {
    public static final GameProfile DEFAULT_CLICKER = new GameProfile(UUID.fromString("36f373ac-29ef-4150-b664-e7e6006efcd8"), "[The Click Machine]");
    ItemStackHandler held = new ItemStackHandler(1);
    EnergyStorage power = new EnergyStorage(ClickMachineConfig.maxPowerStorage);
    GameProfile profile;
    WeakReference<FakePlayerUtil.UsefulFakePlayer> player;
    int counter = 0;
    boolean rightClick = true;
    boolean sneak = false;
    int speedIdx = 0;
    PacketDistributor.TargetPoint us;
    int lastPower = 0;
    LazyOptional<IItemHandler> ihopt = LazyOptional.of(() -> this.held);
    LazyOptional<IEnergyStorage> ieopt = LazyOptional.of(() -> this.power);
    static final String tagUUID = "uuid";
    static final String tagName = "name";
    static final String tagCounter = "counter";
    static final String tagSpeed = "speed_index";
    static final String tagSneak = "sneak";
    static final String tagRightClick = "right_click";
    static final String tagHandler = "inv";
    static final String tagEnergy = "fe";

    public TileAutoClick() {
        super(ClickMachine.TILE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.player == null) {
            this.player = new WeakReference<FakePlayerUtil.UsefulFakePlayer>(FakePlayerUtil.getPlayer(this.field_145850_b, this.profile != null ? this.profile : DEFAULT_CLICKER));
        }
        if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
            int use;
            int n = use = ClickMachineConfig.usesRF ? ClickMachineConfig.powerPerSpeed[this.getSpeedIndex()] : 0;
            if (this.power.extractEnergy(use, true) == use) {
                this.power.extractEnergy(use, false);
                if (this.player != null && this.counter++ % this.getSpeed() == 0) {
                    Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockAutoClick.FACING);
                    FakePlayerUtil.setupFakePlayerForUse(this.getPlayer(), this.field_174879_c, facing, this.held.getStackInSlot(0).func_77946_l(), this.sneak);
                    ItemStack result = this.held.getStackInSlot(0);
                    result = this.rightClick ? FakePlayerUtil.rightClickInDirection(this.getPlayer(), this.field_145850_b, this.field_174879_c, facing, this.field_145850_b.func_180495_p(this.field_174879_c)) : FakePlayerUtil.leftClickInDirection(this.getPlayer(), this.field_145850_b, this.field_174879_c, facing, this.field_145850_b.func_180495_p(this.field_174879_c));
                    FakePlayerUtil.cleanupFakePlayerFromUse(this.getPlayer(), result, this.held.getStackInSlot(0), this);
                    this.func_70296_d();
                }
            }
        }
        if (this.counter % ClickMachineConfig.powerUpdateFreq == 0 && this.power.getEnergyStored() != this.lastPower) {
            NetworkUtils.sendToTracking((SimpleChannel)ClickMachine.CHANNEL, (Object)((Object)new MessageUpdateGui(this.power.getEnergyStored())), (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c);
            this.lastPower = this.power.getEnergyStored();
        }
    }

    public void setPlayer(PlayerEntity player) {
        this.profile = player.func_146103_bH();
        this.func_70296_d();
    }

    public ItemStack insert(ItemStack stack) {
        ItemStack s = this.held.insertItem(0, stack, false);
        this.func_70296_d();
        return s;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.ihopt.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.ieopt.cast();
        }
        return super.getCapability(cap, side);
    }

    FakePlayerUtil.UsefulFakePlayer getPlayer() {
        return (FakePlayerUtil.UsefulFakePlayer)((Object)this.player.get());
    }

    public IItemHandler getHandler() {
        return this.held;
    }

    public int getSpeed() {
        return ClickMachineConfig.speeds[this.getSpeedIndex()];
    }

    public int getSpeedIndex() {
        return this.speedIdx;
    }

    public void setSpeedIndex(int speedIdx) {
        this.speedIdx = speedIdx;
        this.func_70296_d();
    }

    public boolean isSneaking() {
        return this.sneak;
    }

    public void setSneaking(boolean sneak) {
        this.sneak = sneak;
        this.func_70296_d();
    }

    public boolean isRightClicking() {
        return this.rightClick;
    }

    public void setRightClicking(boolean rightClick) {
        this.rightClick = rightClick;
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.profile != null) {
            tag.func_186854_a(tagUUID, this.profile.getId());
            tag.func_74778_a(tagName, this.profile.getName());
        }
        tag.func_218657_a(tagHandler, (INBT)this.held.serializeNBT());
        tag.func_74768_a(tagCounter, this.counter % this.getSpeed());
        this.writeSyncData(tag);
        return super.func_189515_b(tag);
    }

    void writeSyncData(CompoundNBT tag) {
        tag.func_74768_a(tagSpeed, this.getSpeedIndex());
        tag.func_74757_a(tagSneak, this.sneak);
        tag.func_74757_a(tagRightClick, this.rightClick);
        tag.func_74768_a(tagEnergy, this.power.getEnergyStored());
    }

    void readSyncData(CompoundNBT tag) {
        this.setSpeedIndex(tag.func_74762_e(tagSpeed));
        this.sneak = tag.func_74767_n(tagSneak);
        this.rightClick = tag.func_74767_n(tagRightClick);
        this.setPower(tag.func_74762_e(tagEnergy));
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b(tagUUID) && tag.func_74764_b(tagName)) {
            this.profile = new GameProfile(tag.func_186857_a(tagUUID), tag.func_74779_i(tagName));
        }
        if (tag.func_74764_b(tagHandler)) {
            this.held.deserializeNBT(tag.func_74775_l(tagHandler));
        }
        this.counter = tag.func_74762_e(tagCounter);
        this.readSyncData(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.writeSyncData(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 2664, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSyncData(pkt.func_148857_g());
    }

    public int getPower() {
        return this.power.getEnergyStored();
    }

    public void setPower(int energy) {
        this.power.extractEnergy(this.power.getMaxEnergyStored(), false);
        this.power.receiveEnergy(energy, false);
        this.func_70296_d();
    }

    @Override
    public void accept(ItemStack s) {
        this.held.setStackInSlot(0, s);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAutoClick(id, this, player);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.clickmachine.autoclick", new Object[0]);
    }
}

