/*
 * Decompiled with CFR 0.152.
 */
package shadows.click;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.click.ClickMachineConfig;
import shadows.click.block.BlockAutoClick;
import shadows.click.block.TileAutoClick;
import shadows.click.block.gui.ContainerAutoClick;
import shadows.click.block.gui.GuiAutoClick;
import shadows.click.net.MessageUpdateGui;
import shadows.click.util.FakePlayerUtil;
import shadows.placebo.config.Configuration;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.NetworkUtils;

@Mod(value="clickmachine")
public class ClickMachine {
    public static final String MODID = "clickmachine";
    public static final Logger LOG = LogManager.getLogger((String)"clickmachine");
    public static final RecipeHelper HELPER = new RecipeHelper("clickmachine");
    public static final BlockAutoClick AUTO_CLICKER = new BlockAutoClick();
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("clickmachine", "clickmachine")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final ContainerType<ContainerAutoClick> CONTAINER = new ContainerType((ContainerType.IFactory)((IContainerFactory)ContainerAutoClick::new));
    public static final TileEntityType<TileAutoClick> TILE = new TileEntityType(TileAutoClick::new, (Set)ImmutableSet.of((Object)((Object)AUTO_CLICKER)), null);

    public ClickMachine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClickMachineConfig.init(new Configuration(new File(FMLPaths.CONFIGDIR.get().toFile(), "clickmachine.cfg")));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            for (int i = 0; i < 9; ++i) {
                if (ClickMachineConfig.usesRF) {
                    GuiAutoClick.setFormatArgs(i, ClickMachineConfig.speeds[i], ClickMachineConfig.powerPerSpeed[i]);
                    continue;
                }
                GuiAutoClick.setFormatArgs(i, ClickMachineConfig.speeds[i]);
            }
        });
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new MessageUpdateGui());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register(AUTO_CLICKER.setRegistryName(MODID, "auto_clicker"));
        ForgeRegistries.ITEMS.register(new BlockItem((Block)AUTO_CLICKER, new Item.Properties().func_200916_a(ItemGroup.field_78028_d)).setRegistryName(AUTO_CLICKER.getRegistryName()));
    }

    @SubscribeEvent
    public void container(RegistryEvent.Register<ContainerType<?>> e) {
        e.getRegistry().register(CONTAINER.setRegistryName(MODID, "container"));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().register(TILE.setRegistryName(MODID, "tile"));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        Ingredient diorite = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221577_e});
        HELPER.addShaped((Object)AUTO_CLICKER, 3, 3, new Object[]{diorite, diorite, diorite, diorite, Blocks.field_185766_cS, diorite, diorite, Blocks.field_150451_bX, diorite});
        LootSystem.defaultBlockTable((Block)AUTO_CLICKER);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockJoin(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof FakePlayerUtil.UsefulFakePlayer) {
            e.setCanceled(true);
        }
    }
}

