/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.tile;

import com.tfar.metalbarrels.MetalBarrels;
import com.tfar.metalbarrels.container.DiamondBarrelContainer;
import com.tfar.metalbarrels.network.PacketHandler;
import com.tfar.metalbarrels.network.PacketTopStackSyncChest;
import com.tfar.metalbarrels.tile.AbstractBarrelTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.PacketDistributor;

public class CrystalBarrelTile
extends AbstractBarrelTile
implements ITickableTileEntity {
    public NonNullList<ItemStack> topStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private boolean inventoryTouched;
    private boolean hadStuff;

    public CrystalBarrelTile() {
        super(MetalBarrels.ObjectHolders.CRYSTAL_TILE, 12, 9);
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("metalbarrels.crystal_barrel", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new DiamondBarrelContainer(id, this.field_145850_b, this.field_174879_c, playerInventory, player);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
    }

    private void sortTopStacks() {
        int i;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        NonNullList tempCopy = NonNullList.func_191197_a((int)this.handler.getSlots(), (Object)ItemStack.field_190927_a);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack itemStack = this.handler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.func_185132_d((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.func_190916_E() == tempCopyStack.func_190916_E()) continue block0;
                tempCopyStack.func_190917_f(itemStack.func_190916_E());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.func_77946_l());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.topStacks.size(); ++i) {
                this.topStacks.set(i, (Object)ItemStack.field_190927_a);
            }
            if (this.field_145850_b != null) {
                BlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            }
            return;
        }
        this.hadStuff = true;
        tempCopy.sort((stack1, stack2) -> stack1.func_190926_b() ? 1 : (stack2.func_190926_b() ? -1 : stack2.func_190916_E() - stack1.func_190916_E()));
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element.func_190926_b() || element.func_190916_E() <= 0) continue;
            if (p == this.topStacks.size()) break;
            this.topStacks.set(p, (Object)element);
            ++p;
        }
        for (int i2 = p; i2 < this.topStacks.size(); ++i2) {
            this.topStacks.set(i2, (Object)ItemStack.field_190927_a);
        }
        if (this.field_145850_b != null) {
            BlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
        }
        this.sendTopStacksPacket();
    }

    private NonNullList<ItemStack> buildItemStackDataList() {
        NonNullList sortList = NonNullList.func_191197_a((int)this.topStacks.size(), (Object)ItemStack.field_190927_a);
        int pos = 0;
        for (ItemStack is : this.topStacks) {
            if (!is.func_190926_b()) {
                sortList.set(pos, (Object)is);
            } else {
                sortList.set(pos, (Object)ItemStack.field_190927_a);
            }
            ++pos;
        }
        return sortList;
    }

    protected void sendTopStacksPacket() {
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        PacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)this.func_145831_w().func_217349_x(this.func_174877_v())), new PacketTopStackSyncChest(this.func_145831_w().func_201675_m().func_186058_p().func_186068_a(), this.func_174877_v(), stacks));
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.inventoryTouched = true;
    }

    public void receiveMessageFromServer(NonNullList<ItemStack> topStacks) {
        this.topStacks = topStacks;
    }
}

