/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.StringUtils;

@Mod.EventBusSubscriber(modid="aquaculture")
public class FishWeightHandler {
    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        if (!event.getDrops().isEmpty()) {
            ItemStack fish = (ItemStack)event.getDrops().get(0);
            if (((Boolean)AquaConfig.BASIC_OPTIONS.randomWeight.get()).booleanValue()) {
                if (AquacultureAPI.FISH_DATA.hasWeight(fish.func_77973_b())) {
                    FishData fishWeight = AquacultureAPI.FISH_DATA;
                    FishWeightHandler.assignRandomWeight(fish, fishWeight.getMinWeight(fish.func_77973_b()), fishWeight.getMaxWeight(fish.func_77973_b()));
                } else if (fish.func_77973_b().func_206844_a(ItemTags.field_206964_G)) {
                    FishWeightHandler.assignRandomWeight(fish, 0.1, 100.0);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack != null && stack.func_77942_o() && stack.func_77978_p() != null) {
            if (stack.func_77978_p().func_74764_b("fishSize")) {
                Style style = new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.AQUA);
                event.getToolTip().add(new TranslationTextComponent("aquaculture.fishWeight." + StringUtils.toLowerCase((String)stack.func_77978_p().func_74779_i("fishSize")), new Object[0]).func_150255_a(style));
            }
            if (stack.func_77978_p().func_74764_b("fishWeight")) {
                double weight = stack.func_77978_p().func_74769_h("fishWeight");
                String lb = weight == 1.0 ? " lb" : " lbs";
                DecimalFormat df = new DecimalFormat("#,###.##");
                BigDecimal bd = new BigDecimal(weight);
                bd = bd.round(new MathContext(3));
                Style style = new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.GRAY);
                if (bd.doubleValue() > 999.0) {
                    event.getToolTip().add(new TranslationTextComponent("aquaculture.fishWeight.weight", new Object[]{df.format((int)bd.doubleValue()) + lb}).func_150255_a(style));
                } else {
                    event.getToolTip().add(new TranslationTextComponent("aquaculture.fishWeight.weight", new Object[]{bd + lb}).func_150255_a(style));
                }
            }
        }
    }

    private static void assignRandomWeight(ItemStack fish, double min, double max) {
        CompoundNBT tag;
        if (fish.func_190926_b()) {
            return;
        }
        double weight = min + Math.random() * (max - min);
        if (!fish.func_77942_o()) {
            fish.func_77982_d(new CompoundNBT());
        }
        if ((tag = fish.func_77978_p()) != null) {
            tag.func_74780_a("fishWeight", weight);
            if (weight <= max * (double)0.1f) {
                tag.func_74778_a("fishSize", "juvenile");
            } else if (weight > max * (double)0.1f && weight <= max * (double)0.2f) {
                tag.func_74778_a("fishSize", "small");
            } else if (weight >= max * (double)0.8f && weight < max * (double)0.9f) {
                tag.func_74778_a("fishSize", "large");
            } else if (weight >= max * (double)0.9f) {
                tag.func_74778_a("fishSize", "massive");
            }
        }
    }

    public static int getFilletAmountFromWeight(double weight) {
        if (weight >= 2.0 && weight < 10.0) {
            return 1;
        }
        if (weight >= 10.0 && weight < 50.0) {
            return 2;
        }
        if (weight >= 50.0 && weight < 100.0) {
            return 3;
        }
        if (weight >= 100.0 && weight < 150.0) {
            return 4;
        }
        if (weight >= 150.0 && weight < 200.0) {
            return 5;
        }
        if (weight >= 200.0 && weight < 250.0) {
            return 6;
        }
        if (weight >= 250.0 && weight < 300.0) {
            return 7;
        }
        if (weight >= 300.0 && weight < 350.0) {
            return 8;
        }
        if (weight >= 350.0 && weight < 400.0) {
            return 9;
        }
        if (weight >= 400.0 && weight < 450.0) {
            return 10;
        }
        if (weight >= 450.0 && weight < 500.0) {
            return 11;
        }
        if (weight >= 500.0 && weight < 600.0) {
            return 12;
        }
        if (weight >= 600.0 && weight < 700.0) {
            return 13;
        }
        if (weight >= 700.0 && weight < 800.0) {
            return 14;
        }
        if (weight >= 800.0 && weight < 1000.0) {
            return 15;
        }
        if (weight >= 1000.0) {
            return 16;
        }
        return 0;
    }

    public static void registerFishData() {
        AquacultureAPI.FISH_DATA.add(AquaItems.ATLANTIC_COD, 10.0, 211.0, 6);
        AquacultureAPI.FISH_DATA.add(AquaItems.BLACKFISH, 1.0, 28.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.PACIFIC_HALIBUT, 25.0, 550.0, 12);
        AquacultureAPI.FISH_DATA.add(AquaItems.ATLANTIC_HALIBUT, 50.0, 710.0, 14);
        AquacultureAPI.FISH_DATA.add(AquaItems.ATLANTIC_HERRING, 0.5, 2.4);
        AquacultureAPI.FISH_DATA.add(AquaItems.PINK_SALMON, 1.5, 15.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.POLLOCK, 3.0, 46.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.RAINBOW_TROUT, 2.0, 27.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.BAYAD, 5.0, 145.0, 4);
        AquacultureAPI.FISH_DATA.add(AquaItems.BOULTI, 1.0, 9.5, 1);
        AquacultureAPI.FISH_DATA.add(AquaItems.CAPITAINE, 20.0, 440.0, 10);
        AquacultureAPI.FISH_DATA.add(AquaItems.SYNODONTIS, 0.5, 2.5);
        AquacultureAPI.FISH_DATA.add(AquaItems.SMALLMOUTH_BASS, 1.0, 12.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.BLUEGILL, 0.8, 4.5);
        AquacultureAPI.FISH_DATA.add(AquaItems.BROWN_TROUT, 1.5, 44.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.CARP, 2.0, 40.0, 2);
        AquacultureAPI.FISH_DATA.add(AquaItems.CATFISH, 10.0, 220.0, 6);
        AquacultureAPI.FISH_DATA.add(AquaItems.GAR, 8.0, 100.0, 4);
        AquacultureAPI.FISH_DATA.add(AquaItems.MINNOW, 0.2, 1.5, 0);
        AquacultureAPI.FISH_DATA.add(AquaItems.MUSKELLUNGE, 5.0, 70.0, 3);
        AquacultureAPI.FISH_DATA.add(AquaItems.PERCH, 0.5, 6.0);
        AquacultureAPI.FISH_DATA.add(AquaItems.ARAPAIMA, 20.0, 440.0, 10);
        AquacultureAPI.FISH_DATA.add(AquaItems.PIRANHA, 0.5, 7.7);
        AquacultureAPI.FISH_DATA.add(AquaItems.TAMBAQUI, 7.0, 97.0, 3);
        AquacultureAPI.FISH_DATA.add(AquaItems.BROWN_SHROOMA, 1.0, 5.0, 0);
        AquacultureAPI.FISH_DATA.add(AquaItems.RED_SHROOMA, 1.0, 5.0, 0);
        AquacultureAPI.FISH_DATA.add(AquaItems.JELLYFISH, 5.0, 400.0, 0);
        AquacultureAPI.FISH_DATA.add(AquaItems.RED_GROUPER, 4.0, 50.0, 3);
        AquacultureAPI.FISH_DATA.add(AquaItems.TUNA, 30.0, 1508.0, 10);
        AquacultureAPI.FISH_DATA.add(AquaItems.GOLDFISH, 0.05, 5.0, 0);
        AquacultureAPI.FISH_DATA.add(Items.field_196086_aW, 12.0, 211.0, 4);
        AquacultureAPI.FISH_DATA.add(Items.field_196087_aX, 0.6, 15.0, 2);
        AquacultureAPI.FISH_DATA.add(Items.field_196088_aY, 0.01, 1.0, 0);
        AquacultureAPI.FISH_DATA.add(Items.field_196089_aZ, 1.0, 25.0);
    }
}

