/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.misc.BiomeDictionaryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeTagPredicate {
    private static final BiomeTagPredicate ANY = new BiomeTagPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, Lists.newArrayList(), Lists.newArrayList(), false);
    private static final List<BiomeDictionary.Type> INVALID_TAGS = Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END, BiomeDictionary.Type.VOID);
    private final MinMaxBounds.FloatBound x;
    private final MinMaxBounds.FloatBound y;
    private final MinMaxBounds.FloatBound z;
    private final List<BiomeDictionary.Type> include;
    private final List<BiomeDictionary.Type> exclude;
    public final boolean and;

    public BiomeTagPredicate(MinMaxBounds.FloatBound x, MinMaxBounds.FloatBound y, MinMaxBounds.FloatBound z, List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.include = include;
        this.exclude = exclude;
        this.and = and;
    }

    public boolean test(ServerWorld world, float x, float y, float z) {
        if (!this.x.func_211354_d(x)) {
            return false;
        }
        if (!this.y.func_211354_d(y)) {
            return false;
        }
        if (!this.z.func_211354_d(z)) {
            return false;
        }
        BlockPos pos = new BlockPos((double)x, (double)y, (double)z);
        return BiomeTagPredicate.getValidBiomes(this.include, this.exclude, this.and).contains(world.func_226691_t_(pos));
    }

    public static List<Biome> getValidBiomes(List<BiomeDictionary.Type> includeList, List<BiomeDictionary.Type> excludeList, boolean and) {
        ArrayList biomes = Lists.newArrayList();
        if (includeList.isEmpty() && !excludeList.isEmpty()) {
            HashSet validTags = new HashSet(BiomeDictionary.Type.getAll());
            includeList.addAll(validTags);
            excludeList.addAll(INVALID_TAGS);
        }
        if (!includeList.isEmpty()) {
            ArrayList addBiomes = Lists.newArrayList();
            for (BiomeDictionary.Type type : includeList) {
                addBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
            }
            if (and) {
                for (BiomeDictionary.Type type : includeList) {
                    addBiomes.removeIf(biome -> !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type));
                }
            }
            if (includeList.stream().noneMatch(INVALID_TAGS::contains)) {
                excludeList.addAll(INVALID_TAGS);
            }
            for (Biome addBiome : addBiomes) {
                if (biomes.contains(addBiome)) continue;
                biomes.add(addBiome);
            }
        }
        if (!excludeList.isEmpty()) {
            for (BiomeDictionary.Type type : excludeList) {
                biomes.removeAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
            }
        }
        return biomes;
    }

    public JsonElement serialize() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (!(this.x.func_211335_c() && this.y.func_211335_c() && this.z.func_211335_c())) {
            JsonObject posObj = new JsonObject();
            posObj.add("x", this.x.func_200321_c());
            posObj.add("y", this.y.func_200321_c());
            posObj.add("z", this.z.func_200321_c());
            object.add("position", (JsonElement)posObj);
        }
        if (this.include != null) {
            for (BiomeDictionary.Type type : this.include) {
                object.add("include", (JsonElement)object.getAsJsonArray(type.toString()));
            }
        }
        if (this.exclude != null) {
            for (BiomeDictionary.Type type : this.exclude) {
                object.add("exclude", (JsonElement)object.getAsJsonArray(type.toString()));
            }
        }
        object.addProperty("add", Boolean.valueOf(object.getAsBoolean()));
        return object;
    }

    public static BiomeTagPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject location = JSONUtils.func_151210_l((JsonElement)element, (String)"location");
            JsonObject position = JSONUtils.func_151218_a((JsonObject)location, (String)"position", (JsonObject)new JsonObject());
            MinMaxBounds.FloatBound x = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("x"));
            MinMaxBounds.FloatBound y = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("y"));
            MinMaxBounds.FloatBound z = MinMaxBounds.FloatBound.func_211356_a((JsonElement)position.get("z"));
            ArrayList include = Lists.newArrayList();
            if (location.has("include")) {
                JsonArray includeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"include");
                for (int entry = 0; entry < includeArray.size(); ++entry) {
                    BiomeDictionary.Type type = BiomeDictionaryHelper.getType(includeArray.get(entry).getAsString());
                    if (type == null) {
                        Aquaculture.LOG.error("Failed to include BiomeDictionary Tag. Please check your loot tables");
                    }
                    include.add(type);
                }
            }
            ArrayList exclude = Lists.newArrayList();
            if (location.has("exclude")) {
                JsonArray excludeArray = JSONUtils.func_151214_t((JsonObject)location, (String)"exclude");
                for (int entry = 0; entry < excludeArray.size(); ++entry) {
                    BiomeDictionary.Type type = BiomeDictionaryHelper.getType(excludeArray.get(entry).getAsString());
                    if (type == null) {
                        Aquaculture.LOG.error("Failed to exclude BiomeDictionary Tag. Please check your loot tables");
                    }
                    exclude.add(type);
                }
            }
            boolean and = false;
            if (location.has("and")) {
                and = JSONUtils.func_151212_i((JsonObject)location, (String)"and");
            }
            return new BiomeTagPredicate(x, y, z, include, exclude, and);
        }
        return ANY;
    }
}

