/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client;

import com.teammetallurgy.aquaculture.client.gui.screen.TackleBoxScreen;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaBobberRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaFishRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.FishMountRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.TurtleLandRenderer;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.NeptunesBountyRenderer;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.TackleBoxRenderer;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.item.DyeableItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.TippedArrowRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aquaculture", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    public static void setupClient() {
        ScreenManager.func_216911_a(AquaGuis.TACKLE_BOX, TackleBoxScreen::new);
        ClientRegistry.bindTileEntityRenderer(AquaBlocks.AquaTileEntities.NEPTUNES_BOUNTY, NeptunesBountyRenderer::new);
        ClientRegistry.bindTileEntityRenderer(AquaBlocks.AquaTileEntities.TACKLE_BOX, TackleBoxRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.BOBBER, AquaBobberRenderer::new);
        for (EntityType<AquaFishEntity> entityType : FishRegistry.fishEntities) {
            RenderingRegistry.registerEntityRenderingHandler(entityType, manager -> new AquaFishRenderer(manager, fish.getRegistryName() != null && fish.getRegistryName().equals((Object)new ResourceLocation("aquaculture", "jellyfish"))));
        }
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.WATER_ARROW, TippedArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.BOX_TURTLE, TurtleLandRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.ARRAU_TURTLE, TurtleLandRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.STARSHELL_TURTLE, TurtleLandRenderer::new);
        for (EntityType entityType : FishRegistry.fishMounts) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entityType, FishMountRenderer::new);
        }
        ItemColors itemColor = Minecraft.func_71410_x().getItemColors();
        itemColor.func_199877_a((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableItem)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{AquaItems.FISHING_LINE, AquaItems.BOBBER});
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.OAK);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.SPRUCE);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.BIRCH);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.JUNGLE);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.ACACIA);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.DARK_OAK);
    }
}

