/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.hrznstudio.titanium.module.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Module {
    private final String id;
    private final Map<String, Feature> featureMap;
    private final Map<String, Feature> disabledFeatureMap = new HashMap<String, Feature>();
    private final boolean forced;
    private final boolean enabledByDefault;
    private final String description;
    private boolean customFile;

    private Module(String id, Map<String, Feature> featureMap, boolean forced, boolean enabledByDefault, String description, boolean customFile) {
        this.id = id;
        this.featureMap = featureMap;
        this.forced = forced;
        this.enabledByDefault = enabledByDefault;
        this.description = description;
        this.featureMap.values().forEach(f -> f.setModule(this));
        this.customFile = customFile;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public <T extends IForgeRegistryEntry<T>> List<T> getEntries(Class<T> tClass) {
        ArrayList l = new ArrayList();
        this.featureMap.values().forEach(feature -> l.addAll(feature.getEntries(tClass)));
        return l;
    }

    public boolean isForced() {
        return this.forced;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public String getId() {
        return this.id;
    }

    public boolean useCustomeFile() {
        return this.customFile;
    }

    void initConfig(CommentedFileConfig config) {
        new HashMap<String, Feature>(this.featureMap).forEach((id, f) -> {
            String cm = "modules." + this.id + "." + id;
            if (!f.isForced()) {
                boolean active;
                String c = cm + ".enabled";
                config.setComment(cm, f.getDescription());
                boolean bl = active = config.add(c, (Object)f.isEnabledByDefault()) ? f.isEnabledByDefault() : ((Boolean)config.getOrElse(c, (Object)f.isEnabledByDefault())).booleanValue();
                if (active) {
                    f.initConfig(cm, config);
                    f.initEvents();
                } else {
                    this.disabledFeatureMap.put((String)id, this.featureMap.remove(id));
                }
            } else {
                f.initConfig(cm, config);
                f.initEvents();
            }
        });
    }

    public static final class Builder {
        private final String id;
        private final Map<String, Feature> featureMap = new HashMap<String, Feature>();
        private boolean forced;
        private boolean enabledByDefault = true;
        private String description;
        private boolean customFile = false;

        private Builder(String id) {
            this.id = id;
        }

        private Builder feature(Feature feature) {
            this.featureMap.put(feature.getId(), feature);
            return this;
        }

        public Builder force() {
            this.forced = true;
            return this;
        }

        public Builder description(String s) {
            this.description = s;
            return this;
        }

        public Builder disableByDefault() {
            this.enabledByDefault = false;
            return this;
        }

        public Builder feature(Feature.Builder feature) {
            return this.feature(feature.build());
        }

        public Builder useCustomFile() {
            this.customFile = true;
            return this;
        }

        Module build() {
            return new Module(this.id, this.featureMap, this.forced, this.enabledByDefault, this.description, this.customFile);
        }
    }
}

