/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.mods.adhooks.client.HookShotRenderer;
import com.endertech.minecraft.mods.adhooks.client.LauncherModel;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adhooks")
public class AdHooks
extends ForgeMod {
    public static final String ID = "adhooks";
    public static final String NAME = "Advanced Hook Launchers";
    private static AdHooks instance;

    public static AdHooks getInstance() {
        return instance;
    }

    public AdHooks() {
        instance = this;
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(Launcher.KeyPressedMsg::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        for (HookType type : HookType.values()) {
            type.launcher.onClientInit();
        }
        this.registerEntityRender(HookShot.type, HookShotRenderer::new);
    }

    public void commonPostInit() {
    }

    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    public void registerBlocks() {
    }

    public void registerItems() {
        for (HookType type : HookType.values()) {
            this.registerItem((Item)type.hook);
            this.registerItem((Item)type.launcher);
        }
    }

    public void registerEntities() {
        HookShot.type = this.registerEntity("hook_shot", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory(HookShot::new).func_220321_a(0.6f, 0.6f).setTrackingRange(HookShot.RENDER_DISTANCE).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true));
    }

    public void registerTiles() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        for (HookType type : HookType.values()) {
            IBakedModel hook = registry.getModelOf((Item)type.hook);
            IBakedModel launcher = registry.getModelOf((Item)type.launcher);
            registry.replaceModelOf((Item)type.launcher, (IBakedModel)new LauncherModel(launcher, hook));
        }
    }
}

