/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.items;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tmechworks.common.blocks.IBlockItemConstruct;
import slimeknights.tmechworks.common.blocks.RedstoneMachineBlock;

public class MechworksBlockItem
extends BlockItem {
    private Object[] tooltipFormat;
    private Supplier<Object[]> tooltipFormatSupplier = () -> this.tooltipFormat;

    public MechworksBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        if (blockIn instanceof IBlockItemConstruct) {
            ((IBlockItemConstruct)blockIn).onBlockItemConstruct(this);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        Block block = this.func_179223_d();
        if (!(block instanceof RedstoneMachineBlock)) {
            return super.initCapabilities(stack, nbt);
        }
        nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        CompoundNBT tags = new CompoundNBT();
        ((RedstoneMachineBlock)block).setDefaultNBT(nbt, tags);
        if (!tags.isEmpty() && !nbt.func_74764_b("BlockEntityTag")) {
            nbt.func_218657_a("BlockEntityTag", (INBT)tags);
        }
        if (!nbt.isEmpty()) {
            stack.func_77982_d(nbt);
        }
        return null;
    }

    public MechworksBlockItem setTooltipFormat(Object ... format) {
        this.tooltipFormat = format;
        return this;
    }

    public MechworksBlockItem setTooltipFormatSupplier(Supplier<Object[]> formatSupplier) {
        this.tooltipFormatSupplier = formatSupplier;
        return this;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (I18n.func_188566_a((String)(this.func_77667_c(stack) + ".tooltip"))) {
            tooltip.addAll(LocUtils.getTooltips((String)I18n.func_135052_a((String)(this.func_77667_c(stack) + ".tooltip"), (Object[])this.tooltipFormatSupplier.get())).stream().map(x -> x.func_211708_a(TextFormatting.GRAY)).collect(Collectors.toList()));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

