/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.inventory;

import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tmechworks.common.inventory.slots.ISlotValidate;

public class FragmentedInventory
implements IInventory,
ISlotValidate {
    private final IInventory parent;
    private final int startSlot;
    private int size;
    private boolean overrideStackLimit;
    private int stackLimit = 64;
    private Predicate<ItemStack> validItems = stack -> true;

    public FragmentedInventory(IInventory parent, int startSlot, int size) {
        this.parent = parent;
        this.startSlot = startSlot;
        this.size = size;
    }

    public int func_70302_i_() {
        return this.size;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.isSlotInInventory(slot)) {
            return ItemStack.field_190927_a;
        }
        return this.parent.func_70301_a(this.getSlot(slot));
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (!this.isSlotInInventory(slot)) {
            return ItemStack.field_190927_a;
        }
        return this.parent.func_70298_a(this.getSlot(slot), count);
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.isSlotInInventory(slot)) {
            return ItemStack.field_190927_a;
        }
        return this.parent.func_70304_b(this.getSlot(slot));
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (this.isSlotInInventory(slot)) {
            this.parent.func_70299_a(this.getSlot(slot), itemStack);
        }
    }

    public int getSlot(int slot) {
        return slot + this.startSlot;
    }

    public void func_70296_d() {
        this.parent.func_70296_d();
    }

    public void markDirtyFast() {
        if (this.parent instanceof MantleTileEntity) {
            ((MantleTileEntity)this.parent).markDirtyFast();
        } else {
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity playerEntity) {
        return this.parent.func_70300_a(playerEntity);
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public int func_70297_j_() {
        if (this.overrideStackLimit) {
            return this.stackLimit;
        }
        return this.parent.func_70297_j_();
    }

    public FragmentedInventory overrideStackLimit(int stackLimit) {
        this.overrideStackLimit = true;
        this.stackLimit = stackLimit;
        return this;
    }

    public FragmentedInventory setValidItemsPredicate(Predicate<ItemStack> validItemsPredicate) {
        this.validItems = validItemsPredicate;
        return this;
    }

    public void func_174889_b(PlayerEntity player) {
        this.parent.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.parent.func_174886_c(player);
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return this.validItems.test(itemStack) && this.parent.func_94041_b(this.getSlot(slot), itemStack);
    }

    public boolean isSlotInInventory(int i) {
        return i >= 0 && i < this.size && i + this.startSlot < this.parent.func_70302_i_();
    }

    public void resize(int newSize) {
        this.size = newSize;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public boolean isItemValidForValidatingSlot(int slot, ItemStack item) {
        return this.validItems.test(item);
    }
}

