/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tmechworks.client.model.DisguiseBakedModel;

@Mod.EventBusSubscriber(modid="tmechworks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ModelBakeEventListener {
    private static Logger log = LogManager.getLogger((String)"tmechworks.model");
    private static final Set<String> disguiseables = new HashSet<String>();

    public static void registerDisguiseBlock(ResourceLocation location) {
        disguiseables.add(location.toString());
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        float time = System.nanoTime();
        log.info("Starting model bake at " + time);
        ArrayList registry = new ArrayList(event.getModelRegistry().entrySet());
        for (int i = 0; i < registry.size(); ++i) {
            Map.Entry model = (Map.Entry)registry.get(i);
            String modelId = ((ResourceLocation)model.getKey()).toString();
            if (model.getKey() instanceof ModelResourceLocation) {
                ModelResourceLocation modelRes = (ModelResourceLocation)model.getKey();
                modelId = modelRes.func_110624_b() + ":" + modelRes.func_110623_a();
            }
            if (!disguiseables.contains(modelId)) continue;
            event.getModelRegistry().put(model.getKey(), new DisguiseBakedModel((IBakedModel)model.getValue()));
        }
        log.info("Model bake finished in " + ((float)System.nanoTime() - time) / 1.0E9f + " seconds");
    }
}

