/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import slimeknights.tmechworks.TMechworks;
import slimeknights.tmechworks.library.Util;

public class MechworksConfig {
    public static final Path CONFIG_PATH = Paths.get(TMechworks.CONFIG_ROOT.toString(), "Config.toml");
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final WorldGeneration WORLD_GENERATION = new WorldGeneration();
    public static final Drawbridge DRAWBRIDGE = new Drawbridge();
    private static final ForgeConfigSpec SPEC = BUILDER.build();

    public static void load() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).build();
        config.load();
        SPEC.setConfig((CommentedConfig)config);
    }

    public static final class Drawbridge {
        public final ForgeConfigSpec.IntValue extendLength;
        public final ForgeConfigSpec.IntValue extendUpgradeValue;
        public final ForgeConfigSpec.DoubleValue delay;
        public final ForgeConfigSpec.DoubleValue speedUpgradeValue;

        Drawbridge() {
            BUILDER.push("drawbridge");
            this.extendLength = BUILDER.comment("Total drawbridge distance (with upgrades) going above 66 in an advanced drawbridge may cause slots to overlap with player inventory slots").comment("The distance that the base drawbridge can extend").defineInRange("extendLength", 16, 1, 64);
            this.extendUpgradeValue = BUILDER.comment("How much each distance upgrade increases the max distance by").defineInRange("extendUpgradeValue", 16, 0, 64);
            this.delay = BUILDER.comment("The base delay between each block place/destroy").defineInRange("delay", 0.5, 0.0, 2.147483647E9);
            this.speedUpgradeValue = BUILDER.comment("The amount by which each speed upgrade decreases the delay").defineInRange("speedUpgradeValue", 0.1, 0.0, 2.147483647E9);
            BUILDER.pop();
        }
    }

    public static final class WorldGeneration {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final Ore COPPER = new Ore("copper");
        public final Ore ALUMINUM = new Ore("aluminum");

        WorldGeneration() {
            BUILDER.push("world");
            this.enabled = BUILDER.comment("Whether world generation is enabled as a whole").define("enabled", true);
            BUILDER.pop();
        }

        public static class Ore {
            public ForgeConfigSpec.BooleanValue enabled;
            public ForgeConfigSpec.BooleanValue isWhitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> filter;

            Ore(String name) {
                this(name, true);
            }

            Ore(String name, boolean onByDefault) {
                this(name, onByDefault, false, Collections.emptyList());
            }

            Ore(String name, boolean onByDefault, boolean isWhitelist, List<String> filter) {
                BUILDER.push("world." + name);
                this.enabled = BUILDER.comment("Whether or not this ore is generated").define("enabled", onByDefault);
                this.isWhitelist = BUILDER.comment("If true, the filter will act as a whitelist, otherwise, blacklist").define("isWhitelist", isWhitelist);
                this.filter = BUILDER.comment("A list of fully qualified biome names, for example \"minecraft:river\"").defineList("filter", filter, obj -> obj != null && Util.validateResourceName(obj.toString()));
                BUILDER.pop(2);
            }
        }
    }
}

