/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.quark;

import com.endlesnights.naturalslabsmod.blocks.FenceSlabBlock;
import com.endlesnights.torchslabsmod.blocks.quark.GetCandle;
import com.endlesnights.torchslabsmod.blocks.quark.entities.FallingCandleSlabEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import vazkii.quark.building.module.TallowAndCandlesModule;

public class BlockCandleSlab
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)6.0, (double)-8.0, (double)6.0, (double)10.0, (double)0.0, (double)10.0);
    protected final DyeColor color;

    public BlockCandleSlab(Block.Properties properties, DyeColor color) {
        super(Block.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)color.func_196055_e()).func_200943_b(0.2f).func_200951_a(14).func_200947_a(SoundType.field_185854_g));
        this.color = color;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && TallowAndCandlesModule.candlesFall) {
            this.checkFallable((World)worldIn, pos);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_206869_a().contains(SlabBlock.field_196505_a) && worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM || ModList.get().isLoaded("naturalslabsmod") && worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() instanceof FenceSlabBlock;
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() instanceof SlabBlock && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return (float)TallowAndCandlesModule.enchantPower;
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || FallingBlock.func_185759_i((BlockState)worldIn.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) && !worldIn.field_72995_K) {
            FallingCandleSlabEntity fallingblockentity = new FallingCandleSlabEntity(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
            worldIn.func_217376_c((Entity)fallingblockentity);
        }
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 2;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)GetCandle.getParent(this.color));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7 - 0.5;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    protected void onStartFalling(FallingCandleSlabEntity fallingEntity) {
    }

    public static boolean canFallThrough(BlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return state.func_196958_f() || block == Blocks.field_150480_ab || material.func_76224_d();
    }

    public void onEndFalling(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState) {
    }

    public void onBroken(World worldIn, BlockPos pos) {
    }

    public void breakFall(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingCandleSlabEntity entity) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof SlabBlock && worldIn.func_180495_p(pos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM && (worldIn.func_175623_d(pos.func_177984_a()) || worldIn.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_204546_a || worldIn.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_207212_b)) {
            worldIn.func_175656_a(pos.func_177984_a(), fallingState);
        } else if (worldIn.func_175623_d(pos) || worldIn.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a || worldIn.func_204610_c(pos).func_206886_c() == Fluids.field_207212_b || worldIn.func_180495_p(pos).func_177230_c() instanceof TallGrassBlock || worldIn.func_180495_p(pos).func_177230_c() instanceof SnowBlock && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            worldIn.func_175656_a(pos, GetCandle.getParent(this.color).func_176223_P());
        } else if (worldIn.func_180495_p(pos).func_177230_c() instanceof LilyPadBlock) {
            worldIn.func_175656_a(pos, GetCandle.getPad(this.color).func_176223_P());
        } else {
            entity.func_199701_a_(new ItemStack((IItemProvider)GetCandle.getParent(this.color).func_199767_j(), 1));
        }
    }
}

