/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons;

import com.jaquadro.minecraft.extrabuttons.block.CapacitiveTouchBlock;
import com.jaquadro.minecraft.extrabuttons.block.DelayButtonBlock;
import com.jaquadro.minecraft.extrabuttons.block.EntityDetectorRailBlock;
import com.jaquadro.minecraft.extrabuttons.block.EntityPoweredRailBlock;
import com.jaquadro.minecraft.extrabuttons.block.StonePanelButtonBlock;
import com.jaquadro.minecraft.extrabuttons.block.ToggleButtonBlock;
import com.jaquadro.minecraft.extrabuttons.block.WoodPanelButtonBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="extrabuttons")
public class ModBlocks {
    public static final Block WHITE_TOGGLE_BUTTON = null;
    public static final Block ORANGE_TOGGLE_BUTTON = null;
    public static final Block MAGENTA_TOGGLE_BUTTON = null;
    public static final Block LIGHT_BLUE_TOGGLE_BUTTON = null;
    public static final Block YELLOW_TOGGLE_BUTTON = null;
    public static final Block LIME_TOGGLE_BUTTON = null;
    public static final Block PINK_TOGGLE_BUTTON = null;
    public static final Block GRAY_TOGGLE_BUTTON = null;
    public static final Block LIGHT_GRAY_TOGGLE_BUTTON = null;
    public static final Block CYAN_TOGGLE_BUTTON = null;
    public static final Block PURPLE_TOGGLE_BUTTON = null;
    public static final Block BLUE_TOGGLE_BUTTON = null;
    public static final Block BROWN_TOGGLE_BUTTON = null;
    public static final Block GREEN_TOGGLE_BUTTON = null;
    public static final Block RED_TOGGLE_BUTTON = null;
    public static final Block BLACK_TOGGLE_BUTTON = null;
    public static final Block CAPACITIVE_TOUCH_BLOCK = null;
    public static final Block STONE_PANEL_BUTTON = null;
    public static final Block OAK_PANEL_BUTTON = null;
    public static final Block SPRUCE_PANEL_BUTTON = null;
    public static final Block BIRCH_PANEL_BUTTON = null;
    public static final Block JUNGLE_PANEL_BUTTON = null;
    public static final Block ACACIA_PANEL_BUTTON = null;
    public static final Block DARK_OAK_PANEL_BUTTON = null;
    public static final Block DELAY_BUTTON_BLOCK = null;
    public static final Block ENTITY_DETECTOR_RAIL = null;
    public static final Block ENTITY_POWERED_RAIL = null;
    public static List<Block> blockList = new ArrayList<Block>();
    public static List<Block> transportBlocks = new ArrayList<Block>();

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.registerToggleButtonBlock(event, "white_toggle_button", DyeColor.WHITE);
        ModBlocks.registerToggleButtonBlock(event, "orange_toggle_button", DyeColor.ORANGE);
        ModBlocks.registerToggleButtonBlock(event, "magenta_toggle_button", DyeColor.MAGENTA);
        ModBlocks.registerToggleButtonBlock(event, "light_blue_toggle_button", DyeColor.LIGHT_BLUE);
        ModBlocks.registerToggleButtonBlock(event, "yellow_toggle_button", DyeColor.YELLOW);
        ModBlocks.registerToggleButtonBlock(event, "lime_toggle_button", DyeColor.LIME);
        ModBlocks.registerToggleButtonBlock(event, "pink_toggle_button", DyeColor.PINK);
        ModBlocks.registerToggleButtonBlock(event, "gray_toggle_button", DyeColor.GRAY);
        ModBlocks.registerToggleButtonBlock(event, "light_gray_toggle_button", DyeColor.LIGHT_GRAY);
        ModBlocks.registerToggleButtonBlock(event, "cyan_toggle_button", DyeColor.CYAN);
        ModBlocks.registerToggleButtonBlock(event, "purple_toggle_button", DyeColor.PURPLE);
        ModBlocks.registerToggleButtonBlock(event, "blue_toggle_button", DyeColor.BLUE);
        ModBlocks.registerToggleButtonBlock(event, "brown_toggle_button", DyeColor.BROWN);
        ModBlocks.registerToggleButtonBlock(event, "green_toggle_button", DyeColor.GREEN);
        ModBlocks.registerToggleButtonBlock(event, "red_toggle_button", DyeColor.RED);
        ModBlocks.registerToggleButtonBlock(event, "black_toggle_button", DyeColor.BLACK);
        ModBlocks.registerBlock(event, "capacitive_touch_block", new CapacitiveTouchBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q)));
        ModBlocks.registerBlock(event, "stone_panel_button", (Block)new StonePanelButtonBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f)));
        ModBlocks.registerWoodPanelButtonBlock(event, "oak_panel_button");
        ModBlocks.registerWoodPanelButtonBlock(event, "spruce_panel_button");
        ModBlocks.registerWoodPanelButtonBlock(event, "birch_panel_button");
        ModBlocks.registerWoodPanelButtonBlock(event, "jungle_panel_button");
        ModBlocks.registerWoodPanelButtonBlock(event, "acacia_panel_button");
        ModBlocks.registerWoodPanelButtonBlock(event, "dark_oak_panel_button");
        ModBlocks.registerBlock(event, "delay_button", (Block)new DelayButtonBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q)));
        ModBlocks.registerTransportBlock(event, "entity_detector_rail", (Block)new EntityDetectorRailBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        ModBlocks.registerTransportBlock(event, "entity_powered_rail", (Block)new EntityPoweredRailBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
    }

    public static void registerBlockItems(RegistryEvent.Register<Item> event) {
        BlockItem itemBlock;
        for (Block block : blockList) {
            itemBlock = new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78028_d));
            itemBlock.setRegistryName(block.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        }
        for (Block block : transportBlocks) {
            itemBlock = new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78029_e));
            itemBlock.setRegistryName(block.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        }
    }

    public static void setupRenderTypes() {
        RenderTypeLookup.setRenderLayer((Block)ENTITY_DETECTOR_RAIL, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ENTITY_POWERED_RAIL, (RenderType)RenderType.func_228641_d_());
    }

    private static Block registerToggleButtonBlock(RegistryEvent.Register<Block> event, String name, DyeColor color) {
        return ModBlocks.registerBlock(event, name, (Block)new ToggleButtonBlock(color, Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f)));
    }

    private static Block registerWoodPanelButtonBlock(RegistryEvent.Register<Block> event, String name) {
        return ModBlocks.registerBlock(event, name, (Block)new WoodPanelButtonBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f)));
    }

    private static Block registerTransportBlock(RegistryEvent.Register<Block> event, String name, Block block) {
        return ModBlocks.registerBlock(event, name, block, transportBlocks);
    }

    private static Block registerBlock(RegistryEvent.Register<Block> event, String name, Block block) {
        return ModBlocks.registerBlock(event, name, block, blockList);
    }

    private static Block registerBlock(RegistryEvent.Register<Block> event, String name, Block block, List<Block> group) {
        block.setRegistryName(name);
        event.getRegistry().register((IForgeRegistryEntry)block);
        group.add(block);
        return block;
    }
}

