/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config.gui;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.TextBox;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;

public class GuiEditConfigFromString<T>
extends GuiBase {
    private final ConfigFromString<T> config;
    private final ConfigCallback callback;
    private T current;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final TextBox textBox;

    public static <E> void open(ConfigFromString<E> type, @Nullable E value, @Nullable E defaultValue, ConfigCallback callback) {
        ConfigGroup group = new ConfigGroup("group");
        group.add("value", type, value, e -> {}, defaultValue);
        new GuiEditConfigFromString<E>(type, callback).openGui();
    }

    public GuiEditConfigFromString(ConfigFromString<T> c, ConfigCallback cb) {
        this.setSize(230, 54);
        this.config = c;
        this.callback = cb;
        this.current = this.config.value == null ? null : this.config.copy(this.config.value);
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                GuiEditConfigFromString.this.callback.save(false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                GuiEditConfigFromString.this.config.setCurrentValue(GuiEditConfigFromString.this.current);
                GuiEditConfigFromString.this.callback.save(true);
            }

            @Override
            public WidgetType getWidgetType() {
                return GuiEditConfigFromString.this.config.getCanEdit() && GuiEditConfigFromString.this.textBox.isTextValid() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.textBox = new TextBox(this){

            @Override
            public boolean allowInput() {
                return GuiEditConfigFromString.this.config.getCanEdit();
            }

            @Override
            public boolean isValid(String txt) {
                return GuiEditConfigFromString.this.config.parse(null, txt);
            }

            @Override
            public void onTextChanged() {
                GuiEditConfigFromString.this.config.parse(t -> {
                    GuiEditConfigFromString.this.current = t;
                    this.textColor = GuiEditConfigFromString.this.config.getColor(t);
                }, this.getText());
            }

            @Override
            public void onEnterPressed() {
                if (GuiEditConfigFromString.this.config.getCanEdit()) {
                    GuiEditConfigFromString.this.buttonAccept.onClicked(MouseButton.LEFT);
                }
            }
        };
        this.textBox.setPosAndSize(8, 8, this.width - 16, 16);
        this.textBox.setText(this.config.getStringFromValue(this.current));
        this.textBox.textColor = this.config.getColor(this.current);
        this.textBox.setCursorPosition(this.textBox.getText().length());
        this.textBox.setFocused(true);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.config.setCurrentValue(this.current);
            this.callback.save(true);
            return false;
        }
        return false;
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public boolean doesGuiPauseGame() {
        Screen screen = this.getPrevScreen();
        return screen != null && screen.isPauseScreen();
    }
}

