/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network;

import java.util.function.Supplier;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGeneratorsGuiInteract {
    private GeneratorsGuiInteraction interaction;
    private BlockPos tilePosition;
    private int extra;

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, TileEntity tile) {
        this(interaction, tile.func_174877_v());
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, TileEntity tile, int extra) {
        this(interaction, tile.func_174877_v(), extra);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public static void handle(PacketGeneratorsGuiInteract message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            TileEntityMekanism tile = (TileEntityMekanism)MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)message.tilePosition);
            if (tile != null) {
                message.interaction.consume(tile, player, message.extra);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketGeneratorsGuiInteract pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.interaction);
        buf.func_179255_a(pkt.tilePosition);
        buf.func_150787_b(pkt.extra);
    }

    public static PacketGeneratorsGuiInteract decode(PacketBuffer buf) {
        return new PacketGeneratorsGuiInteract((GeneratorsGuiInteraction)buf.func_179257_a(GeneratorsGuiInteraction.class), buf.func_179259_c(), buf.func_150792_a());
    }

    public static enum GeneratorsGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, PlayerEntity, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityReactorController) {
                ((TileEntityReactorController)((Object)tile)).setInjectionRateFromPacket((int)extra);
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, PlayerEntity, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityReactorLogicAdapter) {
                ((TileEntityReactorLogicAdapter)((Object)tile)).setLogicTypeFromPacket(TileEntityReactorLogicAdapter.ReactorLogic.byIndexStatic(extra));
            }
        }));

        private TriConsumer<TileEntityMekanism, PlayerEntity, Integer> consumerForTile;

        private GeneratorsGuiInteraction(TriConsumer<TileEntityMekanism, PlayerEntity, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, PlayerEntity player, int extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }
}

