/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.forge.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeyCodeEntry
extends TooltipListEntry<ModifierKeyCode> {
    private ModifierKeyCode value;
    private Button buttonWidget;
    private Button resetButton;
    private Consumer<ModifierKeyCode> saveConsumer;
    private Supplier<ModifierKeyCode> defaultValue;
    private List<IGuiEventListener> widgets;
    private boolean allowMouse = true;
    private boolean allowKey = true;
    private boolean allowModifiers = true;

    @Deprecated
    public KeyCodeEntry(String fieldName, ModifierKeyCode value, String resetButtonKey, Supplier<ModifierKeyCode> defaultValue, Consumer<ModifierKeyCode> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.value = value;
        this.buttonWidget = new Button(0, 0, 150, 20, "", widget -> {
            this.getScreen().setFocusedBinding(this);
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.value = this.getDefaultValue().orElse(null);
            this.getScreen().setFocusedBinding(null);
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.saveConsumer = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.buttonWidget, this.resetButton});
    }

    public boolean isAllowModifiers() {
        return this.allowModifiers;
    }

    public void setAllowModifiers(boolean allowModifiers) {
        this.allowModifiers = allowModifiers;
    }

    public boolean isAllowKey() {
        return this.allowKey;
    }

    public void setAllowKey(boolean allowKey) {
        this.allowKey = allowKey;
    }

    public boolean isAllowMouse() {
        return this.allowMouse;
    }

    public void setAllowMouse(boolean allowMouse) {
        this.allowMouse = allowMouse;
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public ModifierKeyCode getValue() {
        return this.value;
    }

    public void setValue(ModifierKeyCode value) {
        this.value = value;
    }

    @Override
    public Optional<ModifierKeyCode> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get);
    }

    private String getLocalizedName() {
        return this.value.getLocalizedName();
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && !this.getDefaultValue().get().equals(this.value);
        this.resetButton.y = y;
        this.buttonWidget.active = this.isEditable();
        this.buttonWidget.y = y;
        this.buttonWidget.setMessage(this.getLocalizedName());
        if (this.getScreen().getFocusedBinding() == this) {
            this.buttonWidget.setMessage(ChatFormatting.WHITE + "> " + ChatFormatting.YELLOW + this.buttonWidget.getMessage() + ChatFormatting.WHITE + " <");
        }
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]))), (float)(y + 5), 0xFFFFFF);
            this.resetButton.x = x;
            this.buttonWidget.x = x + this.resetButton.getWidth() + 2;
        } else {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.buttonWidget.x = x + entryWidth - 150;
        }
        this.buttonWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        this.resetButton.render(mouseX, mouseY, delta);
        this.buttonWidget.render(mouseX, mouseY, delta);
    }

    public List<? extends IGuiEventListener> children() {
        return this.widgets;
    }
}

