/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import sonar.fluxnetworks.api.energy.IItemEnergyHandler;
import sonar.fluxnetworks.api.network.IFluxTransfer;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.common.handler.ItemEnergyHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxController;

public class ControllerTransfer
implements IFluxTransfer {
    public final TileFluxController tile;
    private List<PlayerEntity> players = new ArrayList<PlayerEntity>();
    private int timer;
    private static final Predicate<ItemStack> NOT_EMPTY = STACK -> !STACK.func_190926_b();

    public ControllerTransfer(TileFluxController tile) {
        this.tile = tile;
    }

    @Override
    public void onStartCycle() {
        if (this.timer == 0) {
            this.updatePlayers();
        }
        ++this.timer;
        this.timer %= 20;
    }

    @Override
    public void onEndCycle() {
    }

    @Override
    public long removeEnergy(long amount, boolean simulate) {
        return 0L;
    }

    @Override
    public long addEnergy(long amount, boolean simulate) {
        if (this.timer % 4 != 0) {
            return 0L;
        }
        if ((this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_WIRELESS) & 1) == 0) {
            return 0L;
        }
        long received = 0L;
        block0: for (PlayerEntity player : this.players) {
            if (player == null || !player.func_70089_S()) continue;
            Map<Iterable<ItemStack>, Predicate<ItemStack>> inventories = this.getSubInventories(new HashMap<Iterable<ItemStack>, Predicate<ItemStack>>(), player);
            for (Map.Entry<Iterable<ItemStack>, Predicate<ItemStack>> inventory : inventories.entrySet()) {
                for (ItemStack stack : inventory.getKey()) {
                    long receive;
                    IItemEnergyHandler handler;
                    if (!inventory.getValue().test(stack) || (handler = ItemEnergyHandler.getEnergyHandler(stack)) == null || amount - (received += (receive = handler.addEnergy(amount - received, stack, simulate))) > 0L) continue;
                    break block0;
                }
            }
        }
        return received;
    }

    private void updatePlayers() {
        List<NetworkMember> m = this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_PLAYERS);
        ArrayList<PlayerEntity> players = new ArrayList<PlayerEntity>();
        for (NetworkMember p : m) {
            ServerPlayerEntity entity = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(p.getPlayerUUID());
            if (entity == null) continue;
            players.add((PlayerEntity)entity);
        }
        this.players = players;
    }

    private Map<Iterable<ItemStack>, Predicate<ItemStack>> getSubInventories(Map<Iterable<ItemStack>, Predicate<ItemStack>> subInventories, PlayerEntity player) {
        PlayerInventory inv = player.field_71071_by;
        ItemStack heldItem = inv.func_70448_g();
        int wireless = this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_WIRELESS);
        if ((wireless >> 1 & 1) == 1) {
            subInventories.put(Lists.newArrayList((Object[])new ItemStack[]{heldItem}), NOT_EMPTY);
        }
        if ((wireless >> 2 & 1) == 1) {
            subInventories.put((Iterable<ItemStack>)inv.field_184439_c, NOT_EMPTY);
        }
        if ((wireless >> 3 & 1) == 1) {
            subInventories.put(inv.field_70462_a.subList(0, 9), stack -> !stack.func_190926_b() && (heldItem.func_190926_b() || heldItem != stack));
        }
        if ((wireless >> 4 & 1) == 1) {
            subInventories.put((Iterable<ItemStack>)inv.field_70460_b, NOT_EMPTY);
        }
        if ((wireless >> 5 & 1) == 1) {
            // empty if block
        }
        return subInventories;
    }

    @Override
    public void onEnergyAdded(long amount) {
    }

    @Override
    public void onEnergyRemoved(long amount) {
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public ItemStack getDisplayStack() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isInvalid() {
        return this.tile.func_145837_r();
    }

    private static class ItemHandlerIterator
    implements Iterator<ItemStack> {
        private final IItemHandler handler;
        private int count = 0;

        ItemHandlerIterator(IItemHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.handler.getSlots();
        }

        @Override
        public ItemStack next() {
            ItemStack next = this.handler.getStackInSlot(this.count);
            ++this.count;
            return next;
        }
    }
}

