/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.network.EnumAccessType;

public class NetworkMember {
    private UUID playerUUID;
    private String cachedName;
    private EnumAccessType accessPermission;

    NetworkMember() {
    }

    public NetworkMember(CompoundNBT nbt) {
        this.readNetworkNBT(nbt);
    }

    public static NetworkMember createNetworkMember(PlayerEntity player, EnumAccessType permissionLevel) {
        NetworkMember t = new NetworkMember();
        GameProfile profile = player.func_146103_bH();
        t.playerUUID = PlayerEntity.func_146094_a((GameProfile)profile);
        t.cachedName = profile.getName();
        t.accessPermission = permissionLevel;
        return t;
    }

    public static NetworkMember createMemberByUsername(String username) {
        boolean isOffline;
        NetworkMember t = new NetworkMember();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        boolean bl = isOffline = !server.func_71266_T();
        if (!isOffline) {
            PlayerProfileCache cache = server.func_152358_ax();
            GameProfile profile = cache.func_152655_a(username);
            if (profile != null) {
                t.playerUUID = profile.getId();
            } else {
                isOffline = true;
            }
        }
        if (isOffline) {
            t.playerUUID = PlayerEntity.func_175147_b((String)username);
        }
        t.cachedName = username;
        t.accessPermission = EnumAccessType.USER;
        return t;
    }

    public String getCachedName() {
        return this.cachedName;
    }

    public EnumAccessType getAccessPermission() {
        return this.accessPermission;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setAccessPermission(EnumAccessType accessPermission) {
        this.accessPermission = accessPermission;
    }

    public void readNetworkNBT(CompoundNBT nbt) {
        this.playerUUID = nbt.func_186857_a("playerUUID");
        this.cachedName = nbt.func_74779_i("cachedName");
        this.accessPermission = EnumAccessType.values()[nbt.func_74771_c("playerAccess")];
    }

    public CompoundNBT writeNetworkNBT(CompoundNBT nbt) {
        nbt.func_186854_a("playerUUID", this.playerUUID);
        nbt.func_74778_a("cachedName", this.cachedName);
        nbt.func_74774_a("playerAccess", (byte)this.accessPermission.ordinal());
        return nbt;
    }
}

