/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.BiomeBOP;
import biomesoplenty.common.world.BOPLayerUtil;
import java.util.Optional;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum BOPShoreLayer implements ICastleTransformer
{
    INSTANCE;

    private static final int BEACH;
    private static final int SNOWY_BEACH;
    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int BADLANDS_PLATEAU;
    private static final int ERODED_BADLANDS;
    private static final int MODIFIED_WOODED_BADLANDS_PLATEAU;
    private static final int MODIFIED_BADLANDS_PLATEAU;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;
    private static final int MOUNTAIN_EDGE;
    private static final int STONE_SHORE;
    private static final int SWAMP;
    private static final int TAIGA;

    public int func_202748_a(INoiseRandom context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        Biome biome = (Biome)Registry.field_212624_m.func_148745_a(biomeId);
        if (biomeId == MUSHROOM_FIELDS) {
            if (BOPLayerUtil.isShallowOcean(northBiomeId) || BOPLayerUtil.isShallowOcean(eastBiomeId) || BOPLayerUtil.isShallowOcean(southBiomeId) || BOPLayerUtil.isShallowOcean(westBiomeId)) {
                return MUSHROOM_FIELD_SHORE;
            }
        } else if (biome != null && biome.func_201856_r() == Biome.Category.JUNGLE) {
            if (!(BOPShoreLayer.isJungleCompatible(northBiomeId) && BOPShoreLayer.isJungleCompatible(eastBiomeId) && BOPShoreLayer.isJungleCompatible(southBiomeId) && BOPShoreLayer.isJungleCompatible(westBiomeId))) {
                return JUNGLE_EDGE;
            }
            if (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId)) {
                return BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.mangrove, biomeId);
            }
        } else if (biomeId != MOUNTAINS && biomeId != WOODED_MOUNTAINS && biomeId != MOUNTAIN_EDGE) {
            if (biome != null && biome.func_201851_b() == Biome.RainType.SNOW) {
                if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    if (biome instanceof BiomeBOP) {
                        BiomeBOP biomeBOP = (BiomeBOP)biome;
                        if (biomeBOP.beachBiomeId == -1) {
                            return biomeId;
                        }
                    }
                    return SNOWY_BEACH;
                }
            } else if (biomeId != BADLANDS && biomeId != WOODED_BADLANDS_PLATEAU) {
                if (!BOPLayerUtil.isOcean(biomeId) && biomeId != RIVER && biomeId != SWAMP && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    if (biome instanceof BiomeBOP) {
                        BiomeBOP biomeBOP = (BiomeBOP)biome;
                        if (biomeBOP.beachBiomeId != -1) {
                            return biomeBOP.beachBiomeId;
                        }
                        return biomeId;
                    }
                    if (biome == Biomes.field_76782_w || biome == Biomes.field_76792_x || biome == Biomes.field_150574_L || biome == Biomes.field_185446_X || biome == Biomes.field_222370_aw || biome == Biomes.field_222371_ax || biome == Biomes.field_185447_Y) {
                        return BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.mangrove, biomeId);
                    }
                    if (biome == Biomes.field_76768_g || biome == Biomes.field_150590_f || biome == Biomes.field_76784_u || biome == Biomes.field_150578_U || biome == Biomes.field_185432_ad || biome == Biomes.field_150581_V || biome == Biomes.field_185433_ae || biome == Biomes.field_150582_Q || biome == Biomes.field_150583_P || biome == Biomes.field_185429_aa || biome == Biomes.field_185448_Z || biome == Biomes.field_185430_ab || biome == Biomes.field_150585_R) {
                        return BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.gravel_beach, biomeId);
                    }
                    return BEACH;
                }
            } else if (!(BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId) || BOPShoreLayer.isMesa(northBiomeId) && BOPShoreLayer.isMesa(eastBiomeId) && BOPShoreLayer.isMesa(southBiomeId) && BOPShoreLayer.isMesa(westBiomeId))) {
                return DESERT;
            }
        } else if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
            return STONE_SHORE;
        }
        return biomeId;
    }

    private static int getBiomeIdIfPresent(Optional<Biome> biome, int fallbackId) {
        return biome.isPresent() ? Registry.field_212624_m.func_148757_b((Object)biome.get()) : fallbackId;
    }

    private static boolean isJungleCompatible(int biomeId) {
        if (Registry.field_212624_m.func_148745_a(biomeId) != null && ((Biome)Registry.field_212624_m.func_148745_a(biomeId)).func_201856_r() == Biome.Category.JUNGLE) {
            return true;
        }
        return biomeId == JUNGLE_EDGE || biomeId == JUNGLE || biomeId == JUNGLE_HILLS || biomeId == FOREST || biomeId == TAIGA || BOPLayerUtil.isOcean(biomeId);
    }

    private static boolean isMesa(int biomeId) {
        return biomeId == BADLANDS || biomeId == WOODED_BADLANDS_PLATEAU || biomeId == BADLANDS_PLATEAU || biomeId == ERODED_BADLANDS || biomeId == MODIFIED_WOODED_BADLANDS_PLATEAU || biomeId == MODIFIED_BADLANDS_PLATEAU;
    }

    static {
        BEACH = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76787_r);
        SNOWY_BEACH = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150577_O);
        DESERT = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
        MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
        WOODED_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150580_W);
        FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76767_f);
        JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
        JUNGLE_EDGE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150574_L);
        JUNGLE_HILLS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76792_x);
        BADLANDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150589_Z);
        WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
        BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150608_ab);
        ERODED_BADLANDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_185437_ai);
        MODIFIED_WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_185438_aj);
        MODIFIED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_185439_ak);
        MUSHROOM_FIELDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76789_p);
        MUSHROOM_FIELD_SHORE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76788_q);
        RIVER = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76781_i);
        MOUNTAIN_EDGE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76783_v);
        STONE_SHORE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150576_N);
        SWAMP = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76780_h);
        TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
    }
}

