/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BoneSpineFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == BOPBlocks.flesh;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    private int maxHeight = 5;

    public BoneSpineFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random p_212245_3_, BlockPos startPos, NoFeatureConfig p_212245_5_) {
        while (startPos.func_177956_o() > 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        if (!this.checkSpace(world, startPos.func_177984_a())) {
            return false;
        }
        BlockPos pos = startPos.func_177984_a();
        int height = 1 + p_212245_3_.nextInt(this.maxHeight - 1);
        for (int y = 0; y <= height; ++y) {
            this.setBlock(world, pos.func_177982_a(0, y, 0), Blocks.field_189880_di.func_176223_P());
        }
        return true;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.func_202278_a((IWorldWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(IWorld world, BlockPos pos) {
        for (int y = 0; y <= this.maxHeight + 1; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

