/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.screen.EnergyScreen;
import owmii.lib.client.screen.widget.IconButton;
import owmii.lib.energy.Energy;
import owmii.lib.inventory.EnergyContainerBase;
import owmii.lib.inventory.slot.SlotBase;
import owmii.lib.util.Text;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.endercell.EnderCellTile;
import owmii.powah.block.endergate.EnderGateTile;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.network.packet.SSetActiveChannel;

@OnlyIn(value=Dist.CLIENT)
public class EnderCellScreen
extends EnergyScreen<EnderCellTile, EnderCellContainer> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/ender_cell.png");
    public static final ResourceLocation GUI_CONFIG_TEXTURE = new ResourceLocation("lollipop", "textures/gui/container/ender_blank.png");
    public static final ResourceLocation GUI_WIDGETS_TEXTURE = new ResourceLocation("lollipop", "textures/gui/container/ender_widget.png");
    protected IconButton[] channelButtons;

    public EnderCellScreen(EnderCellContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super((EnergyContainerBase)container, playerInventory, name);
        this.channelButtons = new IconButton[((EnderCellTile)this.te).getTotalChannels()];
    }

    protected void init() {
        super.init();
        block0: for (int l = 0; l < 2; ++l) {
            for (int k = 0; k < 8; ++k) {
                int fi = k + l * 8;
                if (fi >= this.channelButtons.length) break block0;
                this.channelButtons[fi] = new IconButton(this.x + 34 + k * 13, this.y + 32 + l * 13, 12, 12, 0, 64, 12, GUI_WIDGETS_TEXTURE, button -> {
                    SSetActiveChannel.send(fi, ((EnderCellTile)this.te).func_174877_v());
                    ((EnderCellTile)this.te).setActiveChannel(fi);
                }, (Screen)this).tooltip("info.powah.channel", TextFormatting.GRAY, new Object[]{"" + TextFormatting.DARK_AQUA + (fi + 1)});
                this.channelButtons[fi].setIconDiff(fi == ((EnderCellTile)this.te).getActiveChannel() ? 12 : 0);
                this.addButton((Widget)this.channelButtons[fi]);
            }
        }
    }

    protected boolean showConfigButton() {
        return !(this.te instanceof EnderGateTile);
    }

    protected void refreshScreen() {
        super.refreshScreen();
        for (int i = 0; i < this.channelButtons.length; ++i) {
            this.channelButtons[i].setIconDiff(i == ((EnderCellTile)this.te).getActiveChannel() ? 12 : 0);
            this.channelButtons[i].visible = !this.configVisible;
        }
    }

    protected void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (this.configVisible) {
            return;
        }
        GameProfile gm = ((EnderCellTile)this.te).getOwner();
        if (gm != null) {
            this.font.func_175063_a(I18n.func_135052_a((String)"info.lollipop.owner", (Object[])new Object[]{gm.getName()}), 33.0f, 11.0f, 5410949);
        }
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)18.0f, (float)19.0f, (float)0.0f);
        GlStateManager.func_227672_b_((float)0.5f, (float)0.5f, (float)1.0f);
        for (int l = 0; l < 2; ++l) {
            for (int k = 0; k < 8; ++k) {
                int fi = k + l * 8;
                this.font.func_211126_b("" + (fi + 1), (float)(42 + k * 26 - (fi >= 9 ? 3 : 0)), (float)(35 + l * 26), fi >= 16 ? 2246721 : 5410949);
            }
        }
        GlStateManager.func_227627_O_();
    }

    protected void drawEnergyGauge(int x, int y, Energy energy) {
        super.drawEnergyGauge(x, y, ((EnderCellTile)this.te).getSyncEnergy());
    }

    public void func_146977_a(Slot slot) {
        if (slot instanceof SlotBase && ((SlotBase)slot).isHidden()) {
            return;
        }
        ItemStack stack = slot.func_75211_c();
        if (((EnderCellTile)this.te).isExtender() && stack.func_77973_b() instanceof IEnderExtender && EnderCellScreen.hasShiftDown()) {
            Energy energy = ((EnderCellTile)this.te).getSyncEnergy();
            IEnderExtender e = (IEnderExtender)stack.func_77973_b();
            long cap = e.getExtendedCapacity(stack);
            long newCap = (long)energy.getMaxEnergyStored() + cap;
            if (cap <= Energy.MAX && newCap > 0L && newCap <= Energy.MAX) {
                RenderHelper.func_74518_a();
                this.bindTexture(GUI_WIDGETS_TEXTURE);
                this.blit(slot.field_75223_e, slot.field_75221_f, 24, 64, 16, 16);
                RenderHelper.func_227784_d_();
            }
        }
        super.func_146977_a(slot);
    }

    public List<String> getTooltipFromItem(ItemStack stack) {
        List tooltip = super.getTooltipFromItem(stack);
        if (((EnderCellTile)this.te).isExtender() && stack.func_77973_b() instanceof IEnderExtender && EnderCellScreen.hasShiftDown()) {
            Energy energy = ((EnderCellTile)this.te).getSyncEnergy();
            IEnderExtender e = (IEnderExtender)stack.func_77973_b();
            long cap = e.getExtendedCapacity(stack);
            long newCap = energy.getCapacity() + cap;
            if (cap <= Energy.MAX && newCap > 0L && newCap <= Energy.MAX) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.channel", (Object[])new Object[]{"" + TextFormatting.DARK_AQUA + (((EnderCellTile)this.te).getActiveChannel() + 1)}));
                info.add("");
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.energy.capacity.fe", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)energy.getCapacity())}));
                info.add(TextFormatting.DARK_AQUA + "+ " + Text.addCommas((long)cap) + " FE");
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.new.capacity", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)newCap)}));
                int stored = energy.getEnergyStored();
                int stackStored = Energy.getStored((ItemStack)stack);
                if (stackStored + stored > stored) {
                    info.add("");
                    info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.energy.fe", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)stored)}));
                    info.add(TextFormatting.DARK_AQUA + "+ " + Text.addCommas((long)stackStored) + " FE");
                    info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.new.energy", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)(stackStored + stored))}));
                }
                info.add("");
                info.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.powah.shift.to.apply", (Object[])new Object[0]));
                return info;
            }
        }
        return tooltip;
    }

    protected ResourceLocation getMachineBackGround() {
        return GUI_TEXTURE;
    }

    protected ResourceLocation getConfigBackGround() {
        return GUI_CONFIG_TEXTURE;
    }

    protected ResourceLocation getWidgetTexture() {
        return GUI_WIDGETS_TEXTURE;
    }
}

