/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.endercell;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import owmii.lib.block.TileBase;
import owmii.lib.energy.Energy;
import owmii.lib.util.IVariant;
import owmii.lib.util.Server;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.endercell.EnderCellBlock;
import owmii.powah.block.endercell.EnderNetwork;

public class EnderCellTile
extends TileBase.EnergyStorage<Tier, EnderCellBlock> {
    protected int activeChannel;
    protected boolean flag;
    @Nullable
    private GameProfile owner;

    public EnderCellTile(TileEntityType<?> tileEntityType, Tier variant) {
        super(tileEntityType, (IVariant)variant);
        this.inv.add(1);
    }

    public EnderCellTile(Tier variant) {
        this(ITiles.ENDER_CELL, variant);
    }

    public EnderCellTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.energy.readCapacity(compound);
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        this.energy.writeCapacity(compound);
        return super.writeSync(compound);
    }

    public void readStorable(CompoundNBT compound) {
        if (compound.func_186855_b("OwnerId")) {
            this.owner = new GameProfile(compound.func_186857_a("OwnerId"), compound.func_74779_i("OwnerName"));
            this.activeChannel = compound.func_74762_e("ActiveChannel");
        }
    }

    public CompoundNBT writeStorable(CompoundNBT compound) {
        if (this.owner != null) {
            compound.func_186854_a("OwnerId", this.owner.getId());
            compound.func_74778_a("OwnerName", this.owner.getName());
            compound.func_74768_a("ActiveChannel", this.activeChannel);
        }
        return compound;
    }

    protected void onFirstTick(World world) {
    }

    protected boolean postTicks(World world) {
        if (!this.isRemote()) {
            this.extendEnderNetwork(world);
            long prevCap = this.energy.getCapacity();
            long prevStored = this.energy.getStored();
            this.energy.setCapacity(this.getEnergyCapacity());
            this.energy.setStored(this.getEnergyStored());
            if (this.flag && (prevCap != this.energy.getStored() || prevStored != this.energy.getCapacity())) {
                this.flag = false;
                this.markDirtyAndSync();
            }
        }
        return super.postTicks(world) || this.isContainerOpen || this.ticks % 100 == 0;
    }

    private void extendEnderNetwork(World world) {
        ItemStack stack = this.inv.getStackInSlot(this.builtInSlots());
        if (this.isExtender() && stack.func_77973_b() instanceof IEnderExtender) {
            Energy energy = this.getEnergyStorage();
            IEnderExtender e = (IEnderExtender)stack.func_77973_b();
            long cap = e.getExtendedCapacity(stack);
            long newCap = energy.getCapacity() + cap;
            if (cap <= Energy.MAX && newCap > 0L && newCap <= Energy.MAX) {
                if (!this.isRemote()) {
                    energy.setCapacity(newCap);
                    energy.setStored(e.getExtendedEnergy(stack) + this.getEnergyStored());
                    this.setEnergyStorage(energy);
                }
                stack.func_190918_g(1);
                world.func_184133_a(null, this.field_174879_c, SoundEvents.field_193777_bb, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public boolean canInsert(int index, ItemStack stack) {
        if (index == this.builtInSlots()) {
            if (this.isExtender() && stack.func_77973_b() instanceof IEnderExtender) {
                Energy energy = this.getEnergyStorage();
                IEnderExtender e = (IEnderExtender)stack.func_77973_b();
                long cap = e.getExtendedCapacity(stack);
                long newCap = energy.getCapacity() + cap;
                return cap <= Energy.MAX && newCap > 0L && newCap <= Energy.MAX;
            }
            return false;
        }
        return super.canInsert(index, stack);
    }

    public void consumeEnergy(long amount) {
        Energy energy = this.getEnergyStorage();
        energy.consume(amount);
        this.setEnergyStorage(energy);
    }

    public void produceEnergy(long amount) {
        Energy energy = this.getEnergyStorage();
        energy.produce(amount);
        this.setEnergyStorage(energy);
    }

    public Energy getEnergyStorage() {
        if (!this.isRemote() && this.owner != null) {
            EnderNetwork network = (EnderNetwork)Server.getData(EnderNetwork::new);
            return network.getStorage(this.owner.getId(), this.activeChannel).setMaxTransfer();
        }
        return Energy.create((long)0L);
    }

    public void setEnergyStorage(Energy energy) {
        if (!this.isRemote() && this.owner != null) {
            EnderNetwork network = (EnderNetwork)Server.getData(EnderNetwork::new);
            network.setStorage(this.owner.getId(), this.activeChannel, energy);
        }
    }

    public Energy getSyncEnergy() {
        return this.energy;
    }

    public void getListedEnergyInfo(List<String> list) {
        super.getListedEnergyInfo(list);
        list.add("");
        list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"info.lollipop.channel", (Object[])new Object[]{"" + TextFormatting.DARK_AQUA + (this.activeChannel + 1)}));
    }

    protected boolean doEnergyTransfer() {
        return this.checkRedstone();
    }

    public long getMaxEnergyReceive() {
        return this.defaultTransfer();
    }

    public long getMaxEnergyExtract() {
        return this.defaultTransfer();
    }

    public void setActiveChannel(int channel) {
        this.activeChannel = Math.min(15, Math.max(0, channel));
        this.flag = true;
    }

    public int getActiveChannel() {
        return this.activeChannel;
    }

    public int getTotalChannels() {
        return ((EnderCellBlock)this.getBlock()).getTotalChannels();
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
    }

    public boolean isExtender() {
        return true;
    }
}

