/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.stal111.forbidden_arcanus.init.ModItems;
import com.stal111.forbidden_arcanus.util.ItemStackUtils;
import com.stal111.forbidden_arcanus.util.VoxelShapeHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LogBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EdelwoodLogBlock
extends LogBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty LEAVES = BooleanProperty.func_177716_a((String)"leaves");
    public static final BooleanProperty OIL = BooleanProperty.func_177716_a((String)"oil");
    private static final VoxelShape INSIDE = EdelwoodLogBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)INSIDE, (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public EdelwoodLogBlock(MaterialColor color, Block.Properties properties) {
        super(color, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176298_M, (Comparable)Direction.Axis.Y)).func_206870_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)OIL, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.func_201670_d() && random.nextDouble() < 0.04 && world.isAreaLoaded(pos, 4) && !((Boolean)state.func_177229_b((IProperty)OIL)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)OIL, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.func_225534_a_(state, world, pos, random);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151069_bo && ((Boolean)state.func_177229_b((IProperty)OIL)).booleanValue()) {
            ItemStackUtils.shrinkStack(player, stack);
            if (!player.func_191521_c(new ItemStack((IItemProvider)ModItems.EDELWOOD_OIL.get()))) {
                player.func_71019_a(new ItemStack((IItemProvider)ModItems.EDELWOOD_OIL.get()), false);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)OIL, (Comparable)Boolean.valueOf(false)), 2);
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() instanceof ShearsItem && ((Boolean)state.func_177229_b((IProperty)LEAVES)).booleanValue()) {
            if (player instanceof ServerPlayerEntity) {
                stack.func_222118_a(1, (LivingEntity)player, player1 -> player1.func_213334_d(hand));
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(false)), 2);
            world.func_184133_a(player, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapeHelper.rotateShapeAxis(SHAPE, (Direction.Axis)state.func_177229_b((IProperty)field_176298_M));
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return VoxelShapeHelper.rotateShapeAxis(INSIDE, (Direction.Axis)state.func_177229_b((IProperty)field_176298_M));
    }

    public void func_176224_k(World world, BlockPos pos) {
        float temperature;
        if (world.field_73012_v.nextDouble() < 0.35 && (temperature = world.func_226691_t_(pos).func_225486_c(pos)) >= 0.15f) {
            BlockState state = world.func_180495_p(pos);
            BlockState stateDown = world.func_180495_p(pos.func_177977_b());
            if (stateDown.func_200132_m() && state.func_177229_b((IProperty)field_176298_M) == Direction.Axis.Y && !((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        Direction.Axis axis = context.func_196000_l().func_176740_k();
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)field_176298_M, (Comparable)axis)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176298_M, LEAVES, OIL, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

