/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityAuraTimer
extends TileEntityImpl
implements ITickableTileEntity {
    private static final Map<IAuraType, Integer> TIMES = ImmutableMap.builder().put((Object)NaturesAuraAPI.TYPE_OVERWORLD, (Object)20).put((Object)NaturesAuraAPI.TYPE_NETHER, (Object)1200).put((Object)NaturesAuraAPI.TYPE_END, (Object)72000).build();
    private final ItemStackHandlerNA itemHandler = new ItemStackHandlerNA(1, this, true){

        @Override
        protected boolean canInsert(ItemStack stack, int slot) {
            return stack.func_77973_b() == ModItems.AURA_BOTTLE;
        }
    };
    private int timer;

    public TileEntityAuraTimer() {
        super(ModTileEntities.AURA_TIMER);
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        if (this.redstonePower <= 0 && newPower > 0) {
            this.timer = 0;
            int color = ItemAuraBottle.getType(this.itemHandler.getStackInSlot(0)).getColor();
            PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.TIMER_RESET, color));
            this.sendToClients();
        }
        super.onRedstonePowerChange(newPower);
    }

    public void func_73660_a() {
        int total = this.getTotalTime();
        if (total <= 0) {
            this.timer = 0;
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                int color = ItemAuraBottle.getType(this.itemHandler.getStackInSlot(0)).getColor();
                NaturesAuraAPI.instance().spawnMagicParticle((float)this.field_174879_c.func_177958_n() + 0.0625f + this.field_145850_b.field_73012_v.nextFloat() * 14.0f / 16.0f, (float)this.field_174879_c.func_177956_o() + 0.0625f + this.field_145850_b.field_73012_v.nextFloat() * 14.0f / 16.0f, (float)this.field_174879_c.func_177952_p() + 0.0625f + this.field_145850_b.field_73012_v.nextFloat() * 14.0f / 16.0f, 0.0, 0.0, 0.0, color, 1.0f, 80 + this.field_145850_b.field_73012_v.nextInt(50), 0.0f, false, true);
            }
            return;
        }
        ++this.timer;
        if (this.timer >= total) {
            this.timer = 0;
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 1);
            this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)state.func_177230_c(), state.func_177230_c().func_149738_a((IWorldReader)this.field_145850_b));
            int color = ItemAuraBottle.getType(this.itemHandler.getStackInSlot(0)).getColor();
            PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.TIMER_RESET, color));
        }
        if (this.timer % 2 == 0) {
            this.sendToClients();
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        Integer amount = TIMES.get(ItemAuraBottle.getType(stack));
        if (amount == null) {
            return 0;
        }
        return amount * stack.func_190916_E();
    }

    public int getTimeLeft() {
        return this.getTotalTime() - this.timer;
    }

    public float getTimerPercentage() {
        return (float)this.timer / (float)this.getTotalTime();
    }

    @Override
    public IItemHandlerModifiable getItemHandler(Direction facing) {
        return this.itemHandler;
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_218657_a("items", (INBT)this.itemHandler.serializeNBT());
            compound.func_74768_a("timer", this.timer);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.itemHandler.deserializeNBT(compound.func_74775_l("items"));
            this.timer = compound.func_74762_e("timer");
        }
    }
}

