/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.aura.type;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;

public class BasicAuraType
implements IAuraType {
    private final ResourceLocation name;
    private final int color;
    private final int priority;
    private final Set<ResourceLocation> dimensions = new HashSet<ResourceLocation>();

    public BasicAuraType(ResourceLocation name, DimensionType dimension, int color, int priority) {
        this.name = name;
        this.color = color;
        this.priority = priority;
        if (dimension != null) {
            this.dimensions.add(dimension.getRegistryName());
        }
    }

    public BasicAuraType register() {
        NaturesAuraAPI.AURA_TYPES.put(this.name, this);
        return this;
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public boolean isPresentInWorld(IWorld world) {
        return this.dimensions.isEmpty() || this.dimensions.contains(world.func_201675_m().func_186058_p().getRegistryName());
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void addDimensionType(ResourceLocation typeName) {
        this.dimensions.add(typeName);
    }
}

