/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.blocks.extractor;

import com.github.commoble.tubesreloaded.common.util.DirectionHelper;
import com.github.commoble.tubesreloaded.common.util.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ExtractorBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected final VoxelShape[] shapes;

    public ExtractorBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isStatePowered;
        boolean isReceivingPower;
        if (!worldIn.field_72995_K && (isReceivingPower = worldIn.func_175640_z(pos)) != (isStatePowered = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue())) {
            if (isReceivingPower) {
                this.transferItem(state, pos, worldIn);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.3f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
            } else {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.1f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isReceivingPower)), 2);
        }
    }

    private void transferItem(BlockState state, BlockPos pos, World world) {
        ItemStack stack;
        LazyOptional<IItemHandler> outputCap;
        Direction output_dir = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos output_pos = pos.func_177972_a(output_dir);
        Direction input_dir = output_dir.func_176734_d();
        BlockPos input_pos = pos.func_177972_a(input_dir);
        LazyOptional<IItemHandler> inputCap = WorldHelper.getTEItemHandlerAt(world, input_pos, output_dir);
        if (inputCap.isPresent() && ((outputCap = WorldHelper.getTEItemHandlerAt(world, output_pos, input_dir)).isPresent() || !world.func_180495_p(output_pos).func_200015_d((IBlockReader)world, output_pos)) && (stack = (ItemStack)inputCap.map(inputHandler -> this.extractNextStack((IItemHandler)inputHandler)).orElse((Object)ItemStack.field_190927_a)).func_190916_E() > 0) {
            ItemStack remaining = (ItemStack)outputCap.map(outputHandler -> this.putStackInHandler(stack, (IItemHandler)outputHandler)).orElse((Object)stack.func_77946_l());
            WorldHelper.ejectItemstack(world, pos, output_dir, remaining);
        }
    }

    private ItemStack extractNextStack(IItemHandler handler) {
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = handler.extractItem(i, 64, false);
            if (stack.func_190916_E() <= 0) continue;
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack putStackInHandler(ItemStack stack, IItemHandler handler) {
        ItemStack remaining = stack.func_77946_l();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            if ((remaining = handler.insertItem(i, remaining, false)).func_190916_E() > 0) continue;
            return ItemStack.field_190927_a;
        }
        return remaining;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)DirectionHelper.getBlockFacingForPlacement(context).func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, POWERED});
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public int getShapeIndex(BlockState state) {
        return ((Direction)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected VoxelShape[] makeShapes() {
        VoxelShape[] shapes = new VoxelShape[6];
        for (int face = 0; face < 6; ++face) {
            double output_z_min;
            double output_y_max;
            double output_y_min;
            double output_x_max;
            double output_x_min;
            double mid_z_max;
            boolean DOWN = face == 0;
            boolean UP = face == 1;
            boolean NORTH = face == 2;
            boolean SOUTH = face == 3;
            boolean WEST = face == 4;
            boolean EAST = face == 5;
            double input_x_min = WEST ? 10.0 : 0.0;
            double input_x_max = EAST ? 6.0 : 16.0;
            double input_y_min = DOWN ? 10.0 : 0.0;
            double input_y_max = UP ? 6.0 : 16.0;
            double input_z_min = NORTH ? 10.0 : 0.0;
            double input_z_max = SOUTH ? 6.0 : 16.0;
            double mid_x_min = EAST ? 6.0 : 4.0;
            double mid_x_max = WEST ? 10.0 : 12.0;
            double mid_y_min = UP ? 6.0 : 4.0;
            double mid_y_max = DOWN ? 10.0 : 12.0;
            double mid_z_min = SOUTH ? 6.0 : 4.0;
            double d = mid_z_max = NORTH ? 10.0 : 12.0;
            double d2 = WEST ? 0.0 : (output_x_min = EAST ? 12.0 : 6.0);
            double d3 = WEST ? 4.0 : (output_x_max = EAST ? 16.0 : 10.0);
            double d4 = DOWN ? 0.0 : (output_y_min = UP ? 12.0 : 6.0);
            double d5 = DOWN ? 4.0 : (output_y_max = UP ? 16.0 : 10.0);
            double d6 = SOUTH ? 12.0 : (output_z_min = NORTH ? 0.0 : 6.0);
            double output_z_max = SOUTH ? 16.0 : (NORTH ? 4.0 : 10.0);
            VoxelShape input = Block.func_208617_a((double)input_x_min, (double)input_y_min, (double)input_z_min, (double)input_x_max, (double)input_y_max, (double)input_z_max);
            VoxelShape mid = Block.func_208617_a((double)mid_x_min, (double)mid_y_min, (double)mid_z_min, (double)mid_x_max, (double)mid_y_max, (double)mid_z_max);
            VoxelShape output = Block.func_208617_a((double)output_x_min, (double)output_y_min, (double)output_z_min, (double)output_x_max, (double)output_y_max, (double)output_z_max);
            shapes[face] = VoxelShapes.func_216384_a((VoxelShape)input, (VoxelShape[])new VoxelShape[]{mid, output});
        }
        return shapes;
    }
}

