/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.blocks.distributor;

import com.github.commoble.tubesreloaded.common.blocks.distributor.DistributorItemHandler;
import com.github.commoble.tubesreloaded.common.registry.TileEntityRegistrar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class DistributorTileEntity
extends TileEntity {
    public static final String NEXT_DIRECTIONS = "next_directions";
    protected final DistributorItemHandler[] handlers = (DistributorItemHandler[])IntStream.range(0, 6).mapToObj(i -> new DistributorItemHandler(this, Direction.func_82600_a((int)i))).toArray(DistributorItemHandler[]::new);
    public final List<LazyOptional<DistributorItemHandler>> handlerOptionals = Arrays.stream(this.handlers).map(handler -> LazyOptional.of(() -> handler)).collect(Collectors.toCollection(ArrayList::new));
    public Direction nextSide = Direction.DOWN;

    public DistributorTileEntity() {
        super(TileEntityRegistrar.DISTRIBUTOR);
    }

    public List<LazyOptional<DistributorItemHandler>> initItemHandlers() {
        return IntStream.range(0, 6).mapToObj(i -> LazyOptional.of(() -> new DistributorItemHandler(this, Direction.func_82600_a((int)i)))).collect(Collectors.toCollection(ArrayList::new));
    }

    public void func_145843_s() {
        this.handlerOptionals.forEach(LazyOptional::invalidate);
        super.func_145843_s();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlerOptionals.get(side.func_176745_a()).cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        CompoundNBT data = super.func_189515_b(nbt);
        data.func_74783_a(NEXT_DIRECTIONS, IntStream.range(0, 6).map(i -> this.handlers[i].getNextDirectionIndex()).toArray());
        return data;
    }

    public void func_145839_a(CompoundNBT nbt) {
        int[] directionIndices = nbt.func_74759_k(NEXT_DIRECTIONS);
        int maxSize = Math.min(this.handlers.length, directionIndices.length);
        for (int i = 0; i < maxSize; ++i) {
            this.handlers[i].setNextDirectionIndex(directionIndices[i]);
        }
        super.func_145839_a(nbt);
    }
}

