/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.jei;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.util.MiscUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SpecialRecipeCategoryExtension
implements ICustomCraftingCategoryExtension {
    private final String name;
    private final List<String> description;
    @Nonnull
    private final SpecialRecipe recipe;
    private final boolean tooltipExists;

    SpecialRecipeCategoryExtension(SpecialRecipe recipe) {
        this.recipe = recipe;
        String path = recipe.func_199560_c().func_110623_a();
        this.tooltipExists = I18n.func_188566_a((String)("jei.recipe." + path + ".name"));
        this.name = I18n.func_135052_a((String)("jei.recipe." + path + ".name"), (Object[])new Object[0]);
        this.description = MiscUtil.wrapString("jei.recipe." + path + ".description");
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients((List)this.recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.func_77571_b());
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.func_199560_c();
    }

    public void setRecipe(IRecipeLayout layout, IIngredients ingredients) {
        if (this.tooltipExists) {
            layout.getItemStacks().addTooltipCallback((index, input, stack, tooltip) -> {
                if (index == 0 && !input) {
                    tooltip.add(TextFormatting.GREEN + TextFormatting.BOLD.toString() + this.name);
                    for (String d : this.description) {
                        tooltip.add(TextFormatting.GREEN + d);
                    }
                }
            });
        }
    }
}

