/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCraftableItemsReady {
    public BlockPos pos;
    public List<ItemStack> list;
    public String command;

    public PacketCraftableItemsReady(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.list = NetworkTools.readItemStackList((PacketBuffer)buf);
    }

    public PacketCraftableItemsReady(BlockPos pos, String command, List<ItemStack> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<ItemStack>();
        this.list.addAll(list);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        NetworkTools.writeItemStackList((PacketBuffer)buf, this.list);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(ItemStack.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

