/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;

public class ProjectionSpellEffect {
    public static boolean projection(PlayerEntity caster, CompoundNBT weaponNBT) {
        int setDamage = MTConfig.PROJECTION_DURABILITY_FACTOR;
        if (weaponNBT != null) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)weaponNBT).func_77946_l();
            stack.func_190920_e(1);
            if (MTConfig.PROJECTION_DURABILITY_FLAT) {
                setDamage = stack.func_77973_b().func_77612_l() - setDamage;
            }
            stack.func_196085_b(setDamage);
            return caster.func_191521_c(stack);
        }
        return false;
    }

    public static CompoundNBT memorize(PlayerEntity caster) {
        if (caster != null) {
            Entity e = ProjectionSpellEffect.playerLook((LivingEntity)caster, MTConfig.GLOBAL_LOOK_RANGE, caster.field_70170_p, ProjectionSpellEffect.getProjectionLookPredicate());
            CompoundNBT ret = new CompoundNBT();
            if (e instanceof LivingEntity) {
                Iterable lst = e.func_184214_aD();
                for (ItemStack tmp : lst) {
                    Item tmpi = tmp.func_77973_b();
                    if (!ProjectionSpellEffect.canProject(tmpi)) continue;
                    tmp.func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof ItemEntity) {
                if (ProjectionSpellEffect.canProject(((ItemEntity)e).func_92059_d().func_77973_b())) {
                    ((ItemEntity)e).func_92059_d().func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof ItemFrameEntity) {
                if (ProjectionSpellEffect.canProject(((ItemFrameEntity)e).func_82335_i().func_77973_b())) {
                    ((ItemFrameEntity)e).func_82335_i().func_77955_b(ret);
                    return ret;
                }
            } else if (e instanceof WeaponProjectileEntity && ProjectionSpellEffect.canProject(((WeaponProjectileEntity)e).getStack().func_77973_b())) {
                ((WeaponProjectileEntity)e).getStack().func_77955_b(ret);
                return ret;
            }
        }
        return null;
    }

    public static boolean canProject(Item tmpi) {
        boolean ret = tmpi instanceof BowItem || tmpi instanceof SwordItem || tmpi instanceof AxeItem || tmpi instanceof HoeItem || tmpi instanceof ShovelItem || tmpi instanceof PickaxeItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem;
        return ret && !ProjectionSpellEffect.disallowed(tmpi);
    }

    public static boolean disallowed(Item tmpi) {
        if (tmpi.getRegistryName() != null) {
            HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_BLACKLIST);
            return disallowed.contains(tmpi.getRegistryName().toString());
        }
        return false;
    }

    public static Entity playerLook(LivingEntity player, double distance, World world, Predicate<Entity> pred) {
        return ProjectionSpellEffect.playerLook(player, distance, world, pred, 1.0f);
    }

    public static Entity playerLook(LivingEntity player, double distance, World world, Predicate<Entity> pred, float collision) {
        Entity ret;
        block5: {
            Entity closestE;
            block6: {
                ret = null;
                if (player == null) break block5;
                RayTraceResult zz = player.func_213324_a(distance, 1.0f, false);
                BlockPos pos = null;
                if (zz instanceof BlockRayTraceResult) {
                    pos = ((BlockRayTraceResult)zz).func_216350_a();
                }
                if (world == null) break block5;
                Vec3d eyes = player.func_174824_e(0.0f);
                Vec3d lookVec = player.func_70040_Z();
                Vec3d sight = eyes.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
                List list = world.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance).func_186662_g(1.0), pred);
                closestE = null;
                Vec3d closestV = null;
                double d3 = 0.0;
                double d2 = 0.0;
                Vec3d normalLook = lookVec.func_72432_b();
                for (int i = 0; i < list.size(); ++i) {
                    Entity tmpEnt = (Entity)list.get(i);
                    AxisAlignedBB aabb = tmpEnt.func_174813_aQ().func_186662_g((double)tmpEnt.func_70111_Y() * (double)collision);
                    boolean result = aabb.func_186668_a(Math.min(eyes.field_72450_a, sight.field_72450_a), Math.min(eyes.field_72448_b, sight.field_72448_b), Math.min(eyes.field_72449_c, sight.field_72449_c), Math.max(eyes.field_72450_a, sight.field_72450_a), Math.max(eyes.field_72448_b, sight.field_72448_b), Math.max(eyes.field_72449_c, sight.field_72449_c));
                    if (aabb.func_72318_a(eyes) || !result || (d3 = eyes.func_72438_d(tmpEnt.func_174824_e(0.0f))) < 0.0 || d2 != 0.0 && !(d3 < d2)) continue;
                    d2 = d3;
                    closestV = tmpEnt.func_174824_e(0.0f);
                    closestE = tmpEnt;
                }
                if (closestE == null || closestV == null || !(eyes.func_72438_d(closestV) < distance)) break block5;
                if (pos == null) break block6;
                Vec3d vec3d = new Vec3d((Vec3i)pos);
                if (!(eyes.func_72438_d(closestV) < eyes.func_72438_d(vec3d))) break block5;
            }
            ret = closestE;
        }
        return ret;
    }

    public static Predicate<Entity> getProjectionLookPredicate() {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity e) {
                return e != null;
            }
        };
    }
}

