/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.core.network.packet.server.RedstoneControlPacket;
import cofh.lib.util.Utils;
import cofh.lib.util.control.IRedstoneControllable;
import cofh.lib.util.control.IRedstoneControllableTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class RedstoneControlModule
implements IRedstoneControllable {
    protected IRedstoneControllableTile tile;
    protected boolean enabled;
    protected int power;
    protected int threshold;
    protected IRedstoneControllable.ControlMode mode = IRedstoneControllable.ControlMode.DISABLED;

    public RedstoneControlModule(IRedstoneControllableTile tile) {
        this(tile, true);
    }

    public RedstoneControlModule(IRedstoneControllableTile tile, boolean enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public RedstoneControlModule setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.power = buffer.readByte();
        this.threshold = buffer.readByte();
        this.mode = IRedstoneControllable.ControlMode.VALUES[buffer.readByte()];
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.power);
        buffer.writeByte(this.threshold);
        buffer.writeByte(this.mode.ordinal());
    }

    public RedstoneControlModule read(CompoundNBT nbt) {
        this.power = nbt.func_74771_c("RSPower");
        this.threshold = nbt.func_74771_c("RSThreshold");
        this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[nbt.func_74771_c("RSMode")];
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.enabled) {
            nbt.func_74774_a("RSPower", (byte)this.power);
            nbt.func_74774_a("RSThreshold", (byte)this.threshold);
            nbt.func_74774_a("RSMode", (byte)this.mode.ordinal());
        }
        return nbt;
    }

    @Override
    public boolean isControllable() {
        return this.enabled;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IRedstoneControllable.ControlMode getMode() {
        return this.mode;
    }

    @Override
    public void setPower(int power) {
        boolean prevState = this.getState();
        this.power = power;
        if (prevState != this.getState() && Utils.isClientWorld(this.tile.world())) {
            this.tile.callBlockUpdate();
        }
    }

    @Override
    public void setControl(int threshold, IRedstoneControllable.ControlMode mode) {
        int curThreshold = this.threshold;
        IRedstoneControllable.ControlMode curMode = this.mode;
        this.threshold = threshold;
        this.mode = mode;
        if (Utils.isClientWorld(this.tile.world())) {
            RedstoneControlPacket.sendToServer(this.tile);
            this.threshold = curThreshold;
            this.mode = curMode;
        } else {
            this.tile.onControlUpdate();
        }
    }
}

