/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.lib.util.helpers.RenderHelper;
import java.util.function.BooleanSupplier;
import net.minecraft.util.ResourceLocation;

public class ElementSlot
extends ElementBase {
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected BooleanSupplier drawUnderlay = TRUE;
    protected BooleanSupplier drawOverlay = TRUE;

    public ElementSlot(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public final ElementSlot setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, TRUE);
    }

    public final ElementSlot setUnderlayTexture(String texture, BooleanSupplier draw) {
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementSlot setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, TRUE);
    }

    public final ElementSlot setOverlayTexture(String texture, BooleanSupplier draw) {
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        this.drawSlot();
        this.drawUnderlayTexture();
        this.drawOverlayTexture();
    }

    protected void drawSlot() {
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.width, this.height);
    }

    protected void drawUnderlayTexture() {
        if (this.drawUnderlay.getAsBoolean() && this.underlayTexture != null) {
            RenderHelper.bindTexture(this.underlayTexture);
            this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.width, this.height);
        }
    }

    protected void drawOverlayTexture() {
        if (this.drawOverlay.getAsBoolean() && this.overlayTexture != null) {
            RenderHelper.bindTexture(this.overlayTexture);
            this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.width, this.height);
        }
    }
}

