/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator.titanium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hrznstudio.titanium.api.material.IResourceHolder;
import com.hrznstudio.titanium.material.ResourceRegistry;
import com.hrznstudio.titanium.recipe.generator.IJSONGenerator;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceRegistryProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;
    private ItemTagsProvider itemTagsProvider;
    private BlockTagsProvider blockTagsProvider;

    public ResourceRegistryProvider(DataGenerator generator) {
        this.generator = generator;
        final HashMap typeBlockMap = new HashMap();
        this.itemTagsProvider = new ItemTagsProvider(generator){

            protected void func_200432_c() {
                HashMap<ResourceLocation, List> typeItemMap = new HashMap<ResourceLocation, List>();
                ResourceRegistry.getMaterials().forEach(material -> material.getGenerated().values().stream().filter(entry -> entry instanceof IResourceHolder).forEach(entry -> {
                    IResourceHolder resourceHolder = (IResourceHolder)entry;
                    String tag = resourceHolder.getType().getTag();
                    String type = resourceHolder.getMaterial().getMaterialType();
                    if (entry instanceof Block) {
                        this.func_200438_a((Tag)new BlockTags.Wrapper(new ResourceLocation("forge", tag + "/" + type)), (Tag)new ItemTags.Wrapper(new ResourceLocation("forge", tag + "/" + type)));
                        typeBlockMap.compute(new ResourceLocation("forge", tag), (resourceLocation, blocks) -> {
                            if (blocks == null) {
                                NonNullList list = NonNullList.func_191196_a();
                                list.add((Block)entry);
                                return list;
                            }
                            blocks.add((Block)entry);
                            return blocks;
                        });
                    } else if (entry instanceof Item) {
                        this.func_200426_a((Tag)new ItemTags.Wrapper(new ResourceLocation("forge", tag + "/" + type))).func_200048_a((Object)((Item)entry));
                        typeItemMap.compute(new ResourceLocation("forge", tag), (resourceLocation, items) -> {
                            if (items == null) {
                                NonNullList list = NonNullList.func_191196_a();
                                list.add((Item)entry);
                                return list;
                            }
                            items.add((Item)entry);
                            return items;
                        });
                    }
                }));
                typeItemMap.forEach((tagLocation, itemList) -> this.func_200426_a((Tag)new ItemTags.Wrapper(tagLocation)).func_200573_a((Object[])itemList.toArray(new Item[itemList.size()])));
            }
        };
        this.blockTagsProvider = new BlockTagsProvider(generator){

            protected void func_200432_c() {
                ResourceRegistry.getMaterials().forEach(material -> material.getGenerated().values().stream().filter(entry -> entry instanceof IResourceHolder).forEach(entry -> {
                    IResourceHolder resourceHolder = (IResourceHolder)entry;
                    String tag = resourceHolder.getType().getTag();
                    String type = resourceHolder.getMaterial().getMaterialType();
                    if (entry instanceof Block) {
                        this.func_200426_a((Tag)new BlockTags.Wrapper(new ResourceLocation("forge", tag + "/" + type))).func_200048_a((Object)((Block)entry));
                        typeBlockMap.compute(new ResourceLocation("forge", tag), (resourceLocation, blocks) -> {
                            if (blocks == null) {
                                NonNullList list = NonNullList.func_191196_a();
                                list.add((Block)entry);
                                return list;
                            }
                            blocks.add((Block)entry);
                            return blocks;
                        });
                    }
                }));
                typeBlockMap.forEach((tagLocation, blockList) -> this.func_200426_a((Tag)new BlockTags.Wrapper(tagLocation)).func_200573_a((Object[])blockList.toArray(new Block[blockList.size()])));
            }
        };
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.itemTagsProvider.func_200398_a(cache);
        this.blockTagsProvider.func_200398_a(cache);
        Path path = this.generator.func_200391_b();
        ResourceRegistry.getMaterials().forEach(material -> material.getGenerated().values().stream().filter(entry -> entry instanceof IJSONGenerator && entry instanceof IJsonFile).forEach(entry -> {
            Path output = path.resolve(((IJsonFile)entry).getRecipeSubfolder() != null ? ((IJsonFile)entry).getRecipeSubfolder() : "");
            try {
                Files.createDirectories(output, new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(output.resolve(((IJsonFile)entry).getRecipeKey() + ".json"), new OpenOption[0]);){
                    bufferedwriter.write(GSON.toJson((JsonElement)((IJSONGenerator)entry).generate()));
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }));
    }

    public String func_200397_b() {
        return "Resource Registry";
    }
}

