/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.function.Function;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import org.apache.commons.lang3.tuple.Pair;

public class SlotsScreenAddon<T extends IComponentHarness>
extends BasicScreenAddon {
    private final InventoryComponent<T> handler;

    public SlotsScreenAddon(InventoryComponent<T> handler) {
        super(handler.getXPos(), handler.getYPos());
        this.handler = handler;
    }

    @Override
    public int getXSize() {
        return 0;
    }

    @Override
    public int getYSize() {
        return 0;
    }

    public static void drawAsset(Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY, int slots, Function<Integer, Pair<Integer, Integer>> positionFunction, boolean drawColor, int color) {
        int posY;
        int posX;
        int slotID;
        IAsset slot = IAssetProvider.getAsset(provider, AssetTypes.SLOT);
        Rectangle area = slot.getArea();
        screen.getMinecraft().func_110434_K().func_110577_a(slot.getResourceLocation());
        if (drawColor) {
            for (slotID = 0; slotID < slots; ++slotID) {
                posX = (Integer)positionFunction.apply(slotID).getLeft();
                posY = (Integer)positionFunction.apply(slotID).getRight();
                AbstractGui.fill((int)(guiX + handlerPosX + posX - 2), (int)(guiY + handlerPosY + posY - 2), (int)(guiX + handlerPosX + posX + area.width), (int)(guiY + handlerPosY + posY + area.height), (int)new Color(color).getRGB());
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        for (slotID = 0; slotID < slots; ++slotID) {
            posX = (Integer)positionFunction.apply(slotID).getLeft();
            posY = (Integer)positionFunction.apply(slotID).getRight();
            AssetUtil.drawAsset(screen, slot, handlerPosX + posX + guiX - 1, handlerPosY + posY + guiY - 1);
        }
        if (drawColor) {
            for (slotID = 0; slotID < slots; ++slotID) {
                posX = (Integer)positionFunction.apply(slotID).getLeft();
                posY = (Integer)positionFunction.apply(slotID).getRight();
                Color colored = new Color(color);
                AbstractGui.fill((int)(guiX + handlerPosX + posX), (int)(guiY + handlerPosY + posY), (int)(guiX + handlerPosX + posX + area.width - 2), (int)(guiY + handlerPosY + posY + area.height - 2), (int)new Color(colored.getRed(), colored.getGreen(), colored.getBlue(), 128).getRGB());
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void drawBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        SlotsScreenAddon.drawAsset(screen, provider, guiX, guiY, this.getPosX(), this.getPosY(), this.handler.getSlots(), this.handler.getSlotPosition(), this.handler instanceof SidedInventoryComponent && ((SidedInventoryComponent)this.handler).isColorGuiEnabled(), this.handler instanceof SidedInventoryComponent ? ((SidedInventoryComponent)this.handler).getColor() : 0);
    }

    @Override
    public void drawForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }
}

