/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.capability.EnergyStorageItemImpl;
import net.silentchaos512.supermultidrills.lib.Constants;
import net.silentchaos512.supermultidrills.part.BatteryPart;
import net.silentchaos512.supermultidrills.part.ChassisPart;
import net.silentchaos512.supermultidrills.part.MotorPart;
import net.silentchaos512.supermultidrills.util.EnergyUtil;
import net.silentchaos512.supermultidrills.util.TextUtil;

public class DrillItem
extends PickaxeItem
implements ICoreTool {
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151574_g, (Object)Material.field_151571_B, (Object)Material.field_151578_c, (Object)Material.field_151592_s, (Object)Material.field_151588_w, (Object)Material.field_151573_f, (Object[])new Material[]{Material.field_151594_q, Material.field_151577_b, Material.field_151598_x, Material.field_76233_E, Material.field_151591_t, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z});
    public static final Set<Material> EXTRA_MATERIALS = ImmutableSet.of((Object)Material.field_215713_z, (Object)Material.field_151572_C, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151575_d, (Object[])new Material[]{Material.field_151580_n});
    public static final GearType GEAR_TYPE = GearType.getOrCreate((String)"drill", (GearType)GearType.HARVEST_TOOL);
    public static final ImmutableSet<ToolType> TOOL_TYPES = ImmutableSet.of((Object)ToolType.PICKAXE, (Object)ToolType.SHOVEL);
    public static final ImmutableSet<ToolType> TOOL_TYPES_WITH_SAW = ImmutableSet.of((Object)ToolType.PICKAXE, (Object)ToolType.SHOVEL, (Object)ToolType.AXE);
    public static final String NBT_BATTERY_CAPACITY = "SMD.BatteryCapacity";
    public static final String NBT_CHASSIS_COLOR = "SMD.ChassisColor";

    public DrillItem() {
        super((IItemTier)ItemTier.DIAMOND, 0, 0.0f, GearHelper.getBuilder((ToolType)ToolType.PICKAXE).addToolType(ToolType.SHOVEL, 3).func_200916_a(SuperMultiDrills.ITEM_GROUP));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    int capacity = DrillItem.getBatteryCapacity(stack);
                    return LazyOptional.of(() -> new EnergyStorageItemImpl(stack, capacity, 100000, 100000)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    private static IEnergyStorage getBatteryCapability(ItemStack stack) {
        PartData part = GearData.getPartOfType((ItemStack)stack, (PartType)BatteryPart.TYPE);
        if (part != null) {
            ItemStack battery = part.getCraftingItem();
            SuperMultiDrills.LOGGER.debug("getBatteryCapability: {}", (Object)battery);
            LazyOptional optional = battery.getCapability(CapabilityEnergy.ENERGY);
            return (IEnergyStorage)optional.orElse((Object)new EnergyStorageItemImpl(battery, 1000000, 1000, 1000));
        }
        return new EnergyStorageItemImpl(stack, 1000000, 1000, 1000);
    }

    public static int getBatteryCapacity(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(NBT_BATTERY_CAPACITY)) {
            return tag.func_74762_e(NBT_BATTERY_CAPACITY);
        }
        IEnergyStorage energy = DrillItem.getBatteryCapability(stack);
        int capacity = energy.getMaxEnergyStored();
        tag.func_74768_a(NBT_BATTERY_CAPACITY, capacity);
        return capacity;
    }

    public static void setBatteryCapacity(ItemStack stack, int capacity) {
        stack.func_196082_o().func_74768_a(NBT_BATTERY_CAPACITY, capacity);
    }

    private static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    public static int getEnergyToBreakBlock(ItemStack stack, BlockState state, float hardness) {
        return Math.round((float)DrillItem.getBaseEnergyCost(stack) * hardness);
    }

    public static int getBaseEnergyCost(ItemStack stack) {
        int efficiencyLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        int silkTouchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack);
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        float durability = GearData.getStat((ItemStack)stack, (ItemStat)ItemStats.DURABILITY);
        int result = (int)Math.round(25.0 + Math.exp(7.0 - 3.0E-4 * (double)durability) * (1.0 + 0.06 * (double)efficiencyLevel));
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public static int getChassisColor(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b(NBT_CHASSIS_COLOR)) {
            return stack.func_196082_o().func_74762_e(NBT_CHASSIS_COLOR);
        }
        return 0xFFFFFF;
    }

    public static void setChassisColor(ItemStack stack, int color) {
        stack.func_196082_o().func_74768_a(NBT_CHASSIS_COLOR, color);
    }

    public static boolean hasSaw(ItemStack stack) {
        return GearData.hasPart((ItemStack)stack, (ResourceLocation)Constants.SAW_UPGRADE);
    }

    public GearType getGearType() {
        return GEAR_TYPE;
    }

    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod((float)0.0f));
        }
        if (stat == ItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod((float)-2.0f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod((float)1.0f));
        }
        return Optional.empty();
    }

    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == ItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod((float)-0.5f));
        }
        return Optional.empty();
    }

    public boolean requiresPartOfType(PartType type) {
        return type == BatteryPart.TYPE || type == ChassisPart.TYPE || type == MotorPart.TYPE || super.requiresPartOfType(type);
    }

    public Set<ItemStat> getRelevantStats(@Nonnull ItemStack stack) {
        return ImmutableSet.of((Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.ATTACK_SPEED, (Object)ItemStats.ENCHANTABILITY, (Object)ItemStats.RARITY, (Object[])new ItemStat[0]);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        int harvestLevel = this.getStatInt(stack, ItemStats.HARVEST_LEVEL);
        if (state.func_177230_c().getHarvestLevel(state) > harvestLevel) {
            return false;
        }
        Material material = state.func_185904_a();
        if (EFFECTIVE_MATERIALS.contains(material) || DrillItem.hasSaw(stack) && EXTRA_MATERIALS.contains(material)) {
            return true;
        }
        return super.canHarvestBlock(stack, state);
    }

    @Deprecated
    public boolean func_150897_b(BlockState state) {
        Material material = state.func_185904_a();
        return EFFECTIVE_MATERIALS.contains(material) || super.func_150897_b(state);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TextUtil.addEnergyInfo(stack, tooltip);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.supermultidrills.drill.energyPerUse", new Object[]{DrillItem.getBaseEnergyCost(stack)}));
        GearClientHelper.addInformation((ItemStack)stack, (World)worldIn, tooltip, (ITooltipFlag)flagIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers((EquipmentSlotType)slot, (ItemStack)stack);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energy = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            boolean canHarvest = this.canHarvestBlock(stack, state);
            boolean hasEnoughPower = energy.getEnergyStored() > DrillItem.getEnergyToBreakBlock(stack, state, 1.0f);
            return canHarvest && hasEnoughPower ? GearHelper.getDestroySpeed((ItemStack)stack, (BlockState)state, EXTRA_MATERIALS) : 1.0f;
        }
        return GearHelper.getDestroySpeed((ItemStack)stack, (BlockState)state, EXTRA_MATERIALS);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return GearHelper.getHarvestLevel((ItemStack)stack, (ToolType)tool, (BlockState)blockState, EXTRA_MATERIALS);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable((ItemStack)toRepair, (ItemStack)repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt((ItemStack)stack, (ItemStat)ItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName((ItemStack)stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt((ItemStack)stack, (ItemStat)ItemStats.DURABILITY);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity((ItemStack)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect((ItemStack)stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int cost = DrillItem.getEnergyToBreakBlock(stack, Blocks.field_150348_b.func_176223_P(), 1.0f);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> EnergyUtil.drainEnergy(e, cost));
        return GearHelper.hitEntity((ItemStack)stack, (LivingEntity)target, (LivingEntity)attacker);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup((ICoreItem)this, (ItemGroup)group, items);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        float hardness = state.func_185887_b((IBlockReader)worldIn, pos);
        if (hardness != 0.0f) {
            int cost = DrillItem.getEnergyToBreakBlock(stack, state, hardness);
            SuperMultiDrills.LOGGER.debug("onBlockDestroyed {} (h={})", (Object)cost, (Object)Float.valueOf(hardness));
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> EnergyUtil.drainEnergy(e, cost));
        }
        return GearHelper.onBlockDestroyed((ItemStack)stack, (World)worldIn, (BlockState)state, (BlockPos)pos, (LivingEntity)entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick((ItemStack)stack, (World)worldIn, (Entity)entityIn, (int)itemSlot, (boolean)isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (DrillItem.hasSaw(stack)) {
            return TOOL_TYPES_WITH_SAW;
        }
        return TOOL_TYPES;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        boolean canceled = super.onBlockStartBreak(stack, pos, player);
        if (!canceled) {
            boolean bl = true;
        }
        return canceled;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - DrillItem.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)((1.0f + DrillItem.getChargeRatio(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getDamage(ItemStack stack) {
        int value = (int)(100.0 * this.getDurabilityForDisplay(stack));
        return MathHelper.func_76125_a((int)value, (int)0, (int)99);
    }
}

