/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.client;

import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.supermultidrills.init.ModItems;
import net.silentchaos512.supermultidrills.item.DrillChassisItem;
import net.silentchaos512.supermultidrills.item.DrillItem;

public class ColorHandlers {
    public static void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.func_199877_a(ColorHandlers::getDrillColor, new IItemProvider[]{ModItems.drill});
        colors.func_199877_a(ColorHandlers::getDrillHeadColor, new IItemProvider[]{ModItems.drillHead});
        colors.func_199877_a((stack, tintIndex) -> DrillChassisItem.getColor(stack), new IItemProvider[]{ModItems.drillChassis});
    }

    private static int getDrillColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return DrillItem.getChassisColor(stack);
        }
        if (tintIndex == 1) {
            return GearData.getHeadColor((ItemStack)stack, (boolean)true);
        }
        if (tintIndex == 4) {
            PartData part = GearData.getPartOfType((ItemStack)stack, (PartType)PartType.TIP);
            if (part == null) {
                return 0xFFFFFF;
            }
            return part.getFallbackColor(stack, 0);
        }
        return 0xFFFFFF;
    }

    private static int getDrillHeadColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return GearData.getHeadColor((ItemStack)stack, (boolean)true);
        }
        return 0xFFFFFF;
    }
}

